<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierGeofenceResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierGeofenceResult extends AbstractStructArrayBase
{
    /**
     * The IdentifierGeofenceResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierGeofenceResult[]
     */
    public $IdentifierGeofenceResult;
    /**
     * Constructor method for ArrayOfIdentifierGeofenceResult
     * @uses ArrayOfIdentifierGeofenceResult::setIdentifierGeofenceResult()
     * @param \StructType\IdentifierGeofenceResult[] $identifierGeofenceResult
     */
    public function __construct(array $identifierGeofenceResult = array())
    {
        $this
            ->setIdentifierGeofenceResult($identifierGeofenceResult);
    }
    /**
     * Get IdentifierGeofenceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierGeofenceResult[]|null
     */
    public function getIdentifierGeofenceResult()
    {
        return isset($this->IdentifierGeofenceResult) ? $this->IdentifierGeofenceResult : null;
    }
    /**
     * Set IdentifierGeofenceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierGeofenceResult[] $identifierGeofenceResult
     * @return \ArrayType\ArrayOfIdentifierGeofenceResult
     */
    public function setIdentifierGeofenceResult(array $identifierGeofenceResult = array())
    {
        foreach ($identifierGeofenceResult as $arrayOfIdentifierGeofenceResultIdentifierGeofenceResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierGeofenceResultIdentifierGeofenceResultItem instanceof \StructType\IdentifierGeofenceResult) {
                throw new \InvalidArgumentException(sprintf('The IdentifierGeofenceResult property can only contain items of \StructType\IdentifierGeofenceResult, "%s" given', is_object($arrayOfIdentifierGeofenceResultIdentifierGeofenceResultItem) ? get_class($arrayOfIdentifierGeofenceResultIdentifierGeofenceResultItem) : gettype($arrayOfIdentifierGeofenceResultIdentifierGeofenceResultItem)), __LINE__);
            }
        }
        if (is_null($identifierGeofenceResult) || (is_array($identifierGeofenceResult) && empty($identifierGeofenceResult))) {
            unset($this->IdentifierGeofenceResult);
        } else {
            $this->IdentifierGeofenceResult = $identifierGeofenceResult;
        }
        return $this;
    }
    /**
     * Add item to IdentifierGeofenceResult value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierGeofenceResult $item
     * @return \ArrayType\ArrayOfIdentifierGeofenceResult
     */
    public function addToIdentifierGeofenceResult(\StructType\IdentifierGeofenceResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierGeofenceResult) {
            throw new \InvalidArgumentException(sprintf('The IdentifierGeofenceResult property can only contain items of \StructType\IdentifierGeofenceResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IdentifierGeofenceResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierGeofenceResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierGeofenceResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierGeofenceResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierGeofenceResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierGeofenceResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierGeofenceResult
     */
    public function getAttributeName()
    {
        return 'IdentifierGeofenceResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIdentifierGeofenceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
