<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifier extends AbstractStructArrayBase
{
    /**
     * The Identifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Identifier[]
     */
    public $Identifier;
    /**
     * Constructor method for ArrayOfIdentifier
     * @uses ArrayOfIdentifier::setIdentifier()
     * @param \StructType\Identifier[] $identifier
     */
    public function __construct(array $identifier = array())
    {
        $this
            ->setIdentifier($identifier);
    }
    /**
     * Get Identifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Identifier[]|null
     */
    public function getIdentifier()
    {
        return isset($this->Identifier) ? $this->Identifier : null;
    }
    /**
     * Set Identifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Identifier[] $identifier
     * @return \ArrayType\ArrayOfIdentifier
     */
    public function setIdentifier(array $identifier = array())
    {
        foreach ($identifier as $arrayOfIdentifierIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierIdentifierItem instanceof \StructType\Identifier) {
                throw new \InvalidArgumentException(sprintf('The Identifier property can only contain items of \StructType\Identifier, "%s" given', is_object($arrayOfIdentifierIdentifierItem) ? get_class($arrayOfIdentifierIdentifierItem) : gettype($arrayOfIdentifierIdentifierItem)), __LINE__);
            }
        }
        if (is_null($identifier) || (is_array($identifier) && empty($identifier))) {
            unset($this->Identifier);
        } else {
            $this->Identifier = $identifier;
        }
        return $this;
    }
    /**
     * Add item to Identifier value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifier $item
     * @return \ArrayType\ArrayOfIdentifier
     */
    public function addToIdentifier(\StructType\Identifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifier) {
            throw new \InvalidArgumentException(sprintf('The Identifier property can only contain items of \StructType\Identifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Identifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Identifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Identifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Identifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Identifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Identifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Identifier
     */
    public function getAttributeName()
    {
        return 'Identifier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
