<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupResultV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupResultV2 extends AbstractStructArrayBase
{
    /**
     * The GroupResultV2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupResultV2[]
     */
    public $GroupResultV2;
    /**
     * Constructor method for ArrayOfGroupResultV2
     * @uses ArrayOfGroupResultV2::setGroupResultV2()
     * @param \StructType\GroupResultV2[] $groupResultV2
     */
    public function __construct(array $groupResultV2 = array())
    {
        $this
            ->setGroupResultV2($groupResultV2);
    }
    /**
     * Get GroupResultV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupResultV2[]|null
     */
    public function getGroupResultV2()
    {
        return isset($this->GroupResultV2) ? $this->GroupResultV2 : null;
    }
    /**
     * Set GroupResultV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupResultV2[] $groupResultV2
     * @return \ArrayType\ArrayOfGroupResultV2
     */
    public function setGroupResultV2(array $groupResultV2 = array())
    {
        foreach ($groupResultV2 as $arrayOfGroupResultV2GroupResultV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfGroupResultV2GroupResultV2Item instanceof \StructType\GroupResultV2) {
                throw new \InvalidArgumentException(sprintf('The GroupResultV2 property can only contain items of \StructType\GroupResultV2, "%s" given', is_object($arrayOfGroupResultV2GroupResultV2Item) ? get_class($arrayOfGroupResultV2GroupResultV2Item) : gettype($arrayOfGroupResultV2GroupResultV2Item)), __LINE__);
            }
        }
        if (is_null($groupResultV2) || (is_array($groupResultV2) && empty($groupResultV2))) {
            unset($this->GroupResultV2);
        } else {
            $this->GroupResultV2 = $groupResultV2;
        }
        return $this;
    }
    /**
     * Add item to GroupResultV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupResultV2 $item
     * @return \ArrayType\ArrayOfGroupResultV2
     */
    public function addToGroupResultV2(\StructType\GroupResultV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupResultV2) {
            throw new \InvalidArgumentException(sprintf('The GroupResultV2 property can only contain items of \StructType\GroupResultV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupResultV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupResultV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupResultV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupResultV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupResultV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupResultV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupResultV2
     */
    public function getAttributeName()
    {
        return 'GroupResultV2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupResultV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
