<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGenericItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfGenericItem extends AbstractStructArrayBase
{
    /**
     * The GenericItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericItem[]
     */
    public $GenericItem;
    /**
     * Constructor method for ArrayOfGenericItem
     * @uses ArrayOfGenericItem::setGenericItem()
     * @param \StructType\GenericItem[] $genericItem
     */
    public function __construct(array $genericItem = array())
    {
        $this
            ->setGenericItem($genericItem);
    }
    /**
     * Get GenericItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericItem[]|null
     */
    public function getGenericItem()
    {
        return isset($this->GenericItem) ? $this->GenericItem : null;
    }
    /**
     * Set GenericItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem[] $genericItem
     * @return \ArrayType\ArrayOfGenericItem
     */
    public function setGenericItem(array $genericItem = array())
    {
        foreach ($genericItem as $arrayOfGenericItemGenericItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfGenericItemGenericItemItem instanceof \StructType\GenericItem) {
                throw new \InvalidArgumentException(sprintf('The GenericItem property can only contain items of \StructType\GenericItem, "%s" given', is_object($arrayOfGenericItemGenericItemItem) ? get_class($arrayOfGenericItemGenericItemItem) : gettype($arrayOfGenericItemGenericItemItem)), __LINE__);
            }
        }
        if (is_null($genericItem) || (is_array($genericItem) && empty($genericItem))) {
            unset($this->GenericItem);
        } else {
            $this->GenericItem = $genericItem;
        }
        return $this;
    }
    /**
     * Add item to GenericItem value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem $item
     * @return \ArrayType\ArrayOfGenericItem
     */
    public function addToGenericItem(\StructType\GenericItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericItem) {
            throw new \InvalidArgumentException(sprintf('The GenericItem property can only contain items of \StructType\GenericItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GenericItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GenericItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GenericItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GenericItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GenericItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GenericItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GenericItem
     */
    public function getAttributeName()
    {
        return 'GenericItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGenericItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
