<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFileTransfer ArrayType
 * @subpackage Arrays
 */
class ArrayOfFileTransfer extends AbstractStructArrayBase
{
    /**
     * The FileTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FileTransfer[]
     */
    public $FileTransfer;
    /**
     * Constructor method for ArrayOfFileTransfer
     * @uses ArrayOfFileTransfer::setFileTransfer()
     * @param \StructType\FileTransfer[] $fileTransfer
     */
    public function __construct(array $fileTransfer = array())
    {
        $this
            ->setFileTransfer($fileTransfer);
    }
    /**
     * Get FileTransfer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FileTransfer[]|null
     */
    public function getFileTransfer()
    {
        return isset($this->FileTransfer) ? $this->FileTransfer : null;
    }
    /**
     * Set FileTransfer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FileTransfer[] $fileTransfer
     * @return \ArrayType\ArrayOfFileTransfer
     */
    public function setFileTransfer(array $fileTransfer = array())
    {
        foreach ($fileTransfer as $arrayOfFileTransferFileTransferItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileTransferFileTransferItem instanceof \StructType\FileTransfer) {
                throw new \InvalidArgumentException(sprintf('The FileTransfer property can only contain items of \StructType\FileTransfer, "%s" given', is_object($arrayOfFileTransferFileTransferItem) ? get_class($arrayOfFileTransferFileTransferItem) : gettype($arrayOfFileTransferFileTransferItem)), __LINE__);
            }
        }
        if (is_null($fileTransfer) || (is_array($fileTransfer) && empty($fileTransfer))) {
            unset($this->FileTransfer);
        } else {
            $this->FileTransfer = $fileTransfer;
        }
        return $this;
    }
    /**
     * Add item to FileTransfer value
     * @throws \InvalidArgumentException
     * @param \StructType\FileTransfer $item
     * @return \ArrayType\ArrayOfFileTransfer
     */
    public function addToFileTransfer(\StructType\FileTransfer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FileTransfer) {
            throw new \InvalidArgumentException(sprintf('The FileTransfer property can only contain items of \StructType\FileTransfer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FileTransfer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FileTransfer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FileTransfer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FileTransfer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FileTransfer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FileTransfer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FileTransfer
     */
    public function getAttributeName()
    {
        return 'FileTransfer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFileTransfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
