<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriverSubGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriverSubGroupItem extends AbstractStructArrayBase
{
    /**
     * The DriverSubGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverSubGroupItem[]
     */
    public $DriverSubGroupItem;
    /**
     * Constructor method for ArrayOfDriverSubGroupItem
     * @uses ArrayOfDriverSubGroupItem::setDriverSubGroupItem()
     * @param \StructType\DriverSubGroupItem[] $driverSubGroupItem
     */
    public function __construct(array $driverSubGroupItem = array())
    {
        $this
            ->setDriverSubGroupItem($driverSubGroupItem);
    }
    /**
     * Get DriverSubGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverSubGroupItem[]|null
     */
    public function getDriverSubGroupItem()
    {
        return isset($this->DriverSubGroupItem) ? $this->DriverSubGroupItem : null;
    }
    /**
     * Set DriverSubGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSubGroupItem[] $driverSubGroupItem
     * @return \ArrayType\ArrayOfDriverSubGroupItem
     */
    public function setDriverSubGroupItem(array $driverSubGroupItem = array())
    {
        foreach ($driverSubGroupItem as $arrayOfDriverSubGroupItemDriverSubGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverSubGroupItemDriverSubGroupItemItem instanceof \StructType\DriverSubGroupItem) {
                throw new \InvalidArgumentException(sprintf('The DriverSubGroupItem property can only contain items of \StructType\DriverSubGroupItem, "%s" given', is_object($arrayOfDriverSubGroupItemDriverSubGroupItemItem) ? get_class($arrayOfDriverSubGroupItemDriverSubGroupItemItem) : gettype($arrayOfDriverSubGroupItemDriverSubGroupItemItem)), __LINE__);
            }
        }
        if (is_null($driverSubGroupItem) || (is_array($driverSubGroupItem) && empty($driverSubGroupItem))) {
            unset($this->DriverSubGroupItem);
        } else {
            $this->DriverSubGroupItem = $driverSubGroupItem;
        }
        return $this;
    }
    /**
     * Add item to DriverSubGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSubGroupItem $item
     * @return \ArrayType\ArrayOfDriverSubGroupItem
     */
    public function addToDriverSubGroupItem(\StructType\DriverSubGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverSubGroupItem) {
            throw new \InvalidArgumentException(sprintf('The DriverSubGroupItem property can only contain items of \StructType\DriverSubGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DriverSubGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DriverSubGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DriverSubGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DriverSubGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DriverSubGroupItem
     */
    public function getAttributeName()
    {
        return 'DriverSubGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDriverSubGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
