<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriverGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriverGroupItem extends AbstractStructArrayBase
{
    /**
     * The DriverGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverGroupItem[]
     */
    public $DriverGroupItem;
    /**
     * Constructor method for ArrayOfDriverGroupItem
     * @uses ArrayOfDriverGroupItem::setDriverGroupItem()
     * @param \StructType\DriverGroupItem[] $driverGroupItem
     */
    public function __construct(array $driverGroupItem = array())
    {
        $this
            ->setDriverGroupItem($driverGroupItem);
    }
    /**
     * Get DriverGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverGroupItem[]|null
     */
    public function getDriverGroupItem()
    {
        return isset($this->DriverGroupItem) ? $this->DriverGroupItem : null;
    }
    /**
     * Set DriverGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DriverGroupItem[] $driverGroupItem
     * @return \ArrayType\ArrayOfDriverGroupItem
     */
    public function setDriverGroupItem(array $driverGroupItem = array())
    {
        foreach ($driverGroupItem as $arrayOfDriverGroupItemDriverGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverGroupItemDriverGroupItemItem instanceof \StructType\DriverGroupItem) {
                throw new \InvalidArgumentException(sprintf('The DriverGroupItem property can only contain items of \StructType\DriverGroupItem, "%s" given', is_object($arrayOfDriverGroupItemDriverGroupItemItem) ? get_class($arrayOfDriverGroupItemDriverGroupItemItem) : gettype($arrayOfDriverGroupItemDriverGroupItemItem)), __LINE__);
            }
        }
        if (is_null($driverGroupItem) || (is_array($driverGroupItem) && empty($driverGroupItem))) {
            unset($this->DriverGroupItem);
        } else {
            $this->DriverGroupItem = $driverGroupItem;
        }
        return $this;
    }
    /**
     * Add item to DriverGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverGroupItem $item
     * @return \ArrayType\ArrayOfDriverGroupItem
     */
    public function addToDriverGroupItem(\StructType\DriverGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverGroupItem) {
            throw new \InvalidArgumentException(sprintf('The DriverGroupItem property can only contain items of \StructType\DriverGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DriverGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DriverGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DriverGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DriverGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DriverGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DriverGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DriverGroupItem
     */
    public function getAttributeName()
    {
        return 'DriverGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDriverGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
