<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocument_V5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocument_V5 extends AbstractStructArrayBase
{
    /**
     * The Document_V5
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Document_V5[]
     */
    public $Document_V5;
    /**
     * Constructor method for ArrayOfDocument_V5
     * @uses ArrayOfDocument_V5::setDocument_V5()
     * @param \StructType\Document_V5[] $document_V5
     */
    public function __construct(array $document_V5 = array())
    {
        $this
            ->setDocument_V5($document_V5);
    }
    /**
     * Get Document_V5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Document_V5[]|null
     */
    public function getDocument_V5()
    {
        return isset($this->Document_V5) ? $this->Document_V5 : null;
    }
    /**
     * Set Document_V5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V5[] $document_V5
     * @return \ArrayType\ArrayOfDocument_V5
     */
    public function setDocument_V5(array $document_V5 = array())
    {
        foreach ($document_V5 as $arrayOfDocument_V5Document_V5Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocument_V5Document_V5Item instanceof \StructType\Document_V5) {
                throw new \InvalidArgumentException(sprintf('The Document_V5 property can only contain items of \StructType\Document_V5, "%s" given', is_object($arrayOfDocument_V5Document_V5Item) ? get_class($arrayOfDocument_V5Document_V5Item) : gettype($arrayOfDocument_V5Document_V5Item)), __LINE__);
            }
        }
        if (is_null($document_V5) || (is_array($document_V5) && empty($document_V5))) {
            unset($this->Document_V5);
        } else {
            $this->Document_V5 = $document_V5;
        }
        return $this;
    }
    /**
     * Add item to Document_V5 value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V5 $item
     * @return \ArrayType\ArrayOfDocument_V5
     */
    public function addToDocument_V5(\StructType\Document_V5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_V5) {
            throw new \InvalidArgumentException(sprintf('The Document_V5 property can only contain items of \StructType\Document_V5, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document_V5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Document_V5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Document_V5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Document_V5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Document_V5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Document_V5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Document_V5
     */
    public function getAttributeName()
    {
        return 'Document_V5';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDocument_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
