<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentResult_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentResult_V2 extends AbstractStructArrayBase
{
    /**
     * The DocumentResult_V2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentResult_V2[]
     */
    public $DocumentResult_V2;
    /**
     * Constructor method for ArrayOfDocumentResult_V2
     * @uses ArrayOfDocumentResult_V2::setDocumentResult_V2()
     * @param \StructType\DocumentResult_V2[] $documentResult_V2
     */
    public function __construct(array $documentResult_V2 = array())
    {
        $this
            ->setDocumentResult_V2($documentResult_V2);
    }
    /**
     * Get DocumentResult_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentResult_V2[]|null
     */
    public function getDocumentResult_V2()
    {
        return isset($this->DocumentResult_V2) ? $this->DocumentResult_V2 : null;
    }
    /**
     * Set DocumentResult_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V2[] $documentResult_V2
     * @return \ArrayType\ArrayOfDocumentResult_V2
     */
    public function setDocumentResult_V2(array $documentResult_V2 = array())
    {
        foreach ($documentResult_V2 as $arrayOfDocumentResult_V2DocumentResult_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentResult_V2DocumentResult_V2Item instanceof \StructType\DocumentResult_V2) {
                throw new \InvalidArgumentException(sprintf('The DocumentResult_V2 property can only contain items of \StructType\DocumentResult_V2, "%s" given', is_object($arrayOfDocumentResult_V2DocumentResult_V2Item) ? get_class($arrayOfDocumentResult_V2DocumentResult_V2Item) : gettype($arrayOfDocumentResult_V2DocumentResult_V2Item)), __LINE__);
            }
        }
        if (is_null($documentResult_V2) || (is_array($documentResult_V2) && empty($documentResult_V2))) {
            unset($this->DocumentResult_V2);
        } else {
            $this->DocumentResult_V2 = $documentResult_V2;
        }
        return $this;
    }
    /**
     * Add item to DocumentResult_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V2 $item
     * @return \ArrayType\ArrayOfDocumentResult_V2
     */
    public function addToDocumentResult_V2(\StructType\DocumentResult_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentResult_V2) {
            throw new \InvalidArgumentException(sprintf('The DocumentResult_V2 property can only contain items of \StructType\DocumentResult_V2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocumentResult_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentResult_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentResult_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentResult_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentResult_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentResult_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentResult_V2
     */
    public function getAttributeName()
    {
        return 'DocumentResult_V2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDocumentResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
