<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDayCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfDayCode extends AbstractStructArrayBase
{
    /**
     * The DayCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DayCode[]
     */
    public $DayCode;
    /**
     * Constructor method for ArrayOfDayCode
     * @uses ArrayOfDayCode::setDayCode()
     * @param \StructType\DayCode[] $dayCode
     */
    public function __construct(array $dayCode = array())
    {
        $this
            ->setDayCode($dayCode);
    }
    /**
     * Get DayCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DayCode[]|null
     */
    public function getDayCode()
    {
        return isset($this->DayCode) ? $this->DayCode : null;
    }
    /**
     * Set DayCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DayCode[] $dayCode
     * @return \ArrayType\ArrayOfDayCode
     */
    public function setDayCode(array $dayCode = array())
    {
        foreach ($dayCode as $arrayOfDayCodeDayCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfDayCodeDayCodeItem instanceof \StructType\DayCode) {
                throw new \InvalidArgumentException(sprintf('The DayCode property can only contain items of \StructType\DayCode, "%s" given', is_object($arrayOfDayCodeDayCodeItem) ? get_class($arrayOfDayCodeDayCodeItem) : gettype($arrayOfDayCodeDayCodeItem)), __LINE__);
            }
        }
        if (is_null($dayCode) || (is_array($dayCode) && empty($dayCode))) {
            unset($this->DayCode);
        } else {
            $this->DayCode = $dayCode;
        }
        return $this;
    }
    /**
     * Add item to DayCode value
     * @throws \InvalidArgumentException
     * @param \StructType\DayCode $item
     * @return \ArrayType\ArrayOfDayCode
     */
    public function addToDayCode(\StructType\DayCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DayCode) {
            throw new \InvalidArgumentException(sprintf('The DayCode property can only contain items of \StructType\DayCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DayCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DayCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DayCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DayCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DayCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DayCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DayCode
     */
    public function getAttributeName()
    {
        return 'DayCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDayCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
