<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConnectGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfConnectGroup extends AbstractStructArrayBase
{
    /**
     * The ConnectGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ConnectGroup[]
     */
    public $ConnectGroup;
    /**
     * Constructor method for ArrayOfConnectGroup
     * @uses ArrayOfConnectGroup::setConnectGroup()
     * @param \StructType\ConnectGroup[] $connectGroup
     */
    public function __construct(array $connectGroup = array())
    {
        $this
            ->setConnectGroup($connectGroup);
    }
    /**
     * Get ConnectGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConnectGroup[]|null
     */
    public function getConnectGroup()
    {
        return isset($this->ConnectGroup) ? $this->ConnectGroup : null;
    }
    /**
     * Set ConnectGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectGroup[] $connectGroup
     * @return \ArrayType\ArrayOfConnectGroup
     */
    public function setConnectGroup(array $connectGroup = array())
    {
        foreach ($connectGroup as $arrayOfConnectGroupConnectGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfConnectGroupConnectGroupItem instanceof \StructType\ConnectGroup) {
                throw new \InvalidArgumentException(sprintf('The ConnectGroup property can only contain items of \StructType\ConnectGroup, "%s" given', is_object($arrayOfConnectGroupConnectGroupItem) ? get_class($arrayOfConnectGroupConnectGroupItem) : gettype($arrayOfConnectGroupConnectGroupItem)), __LINE__);
            }
        }
        if (is_null($connectGroup) || (is_array($connectGroup) && empty($connectGroup))) {
            unset($this->ConnectGroup);
        } else {
            $this->ConnectGroup = $connectGroup;
        }
        return $this;
    }
    /**
     * Add item to ConnectGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectGroup $item
     * @return \ArrayType\ArrayOfConnectGroup
     */
    public function addToConnectGroup(\StructType\ConnectGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectGroup) {
            throw new \InvalidArgumentException(sprintf('The ConnectGroup property can only contain items of \StructType\ConnectGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ConnectGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ConnectGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ConnectGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ConnectGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ConnectGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ConnectGroup
     */
    public function getAttributeName()
    {
        return 'ConnectGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfConnectGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
