<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBorderCrossing ArrayType
 * @subpackage Arrays
 */
class ArrayOfBorderCrossing extends AbstractStructArrayBase
{
    /**
     * The BorderCrossing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BorderCrossing[]
     */
    public $BorderCrossing;
    /**
     * Constructor method for ArrayOfBorderCrossing
     * @uses ArrayOfBorderCrossing::setBorderCrossing()
     * @param \StructType\BorderCrossing[] $borderCrossing
     */
    public function __construct(array $borderCrossing = array())
    {
        $this
            ->setBorderCrossing($borderCrossing);
    }
    /**
     * Get BorderCrossing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BorderCrossing[]|null
     */
    public function getBorderCrossing()
    {
        return isset($this->BorderCrossing) ? $this->BorderCrossing : null;
    }
    /**
     * Set BorderCrossing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BorderCrossing[] $borderCrossing
     * @return \ArrayType\ArrayOfBorderCrossing
     */
    public function setBorderCrossing(array $borderCrossing = array())
    {
        foreach ($borderCrossing as $arrayOfBorderCrossingBorderCrossingItem) {
            // validation for constraint: itemType
            if (!$arrayOfBorderCrossingBorderCrossingItem instanceof \StructType\BorderCrossing) {
                throw new \InvalidArgumentException(sprintf('The BorderCrossing property can only contain items of \StructType\BorderCrossing, "%s" given', is_object($arrayOfBorderCrossingBorderCrossingItem) ? get_class($arrayOfBorderCrossingBorderCrossingItem) : gettype($arrayOfBorderCrossingBorderCrossingItem)), __LINE__);
            }
        }
        if (is_null($borderCrossing) || (is_array($borderCrossing) && empty($borderCrossing))) {
            unset($this->BorderCrossing);
        } else {
            $this->BorderCrossing = $borderCrossing;
        }
        return $this;
    }
    /**
     * Add item to BorderCrossing value
     * @throws \InvalidArgumentException
     * @param \StructType\BorderCrossing $item
     * @return \ArrayType\ArrayOfBorderCrossing
     */
    public function addToBorderCrossing(\StructType\BorderCrossing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BorderCrossing) {
            throw new \InvalidArgumentException(sprintf('The BorderCrossing property can only contain items of \StructType\BorderCrossing, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BorderCrossing[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BorderCrossing|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BorderCrossing|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BorderCrossing|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BorderCrossing|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BorderCrossing|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BorderCrossing
     */
    public function getAttributeName()
    {
        return 'BorderCrossing';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBorderCrossing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
