<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAnomaly_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfAnomaly_V2 extends AbstractStructArrayBase
{
    /**
     * The Anomaly_V2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anomaly_V2[]
     */
    public $Anomaly_V2;
    /**
     * Constructor method for ArrayOfAnomaly_V2
     * @uses ArrayOfAnomaly_V2::setAnomaly_V2()
     * @param \StructType\Anomaly_V2[] $anomaly_V2
     */
    public function __construct(array $anomaly_V2 = array())
    {
        $this
            ->setAnomaly_V2($anomaly_V2);
    }
    /**
     * Get Anomaly_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anomaly_V2[]|null
     */
    public function getAnomaly_V2()
    {
        return isset($this->Anomaly_V2) ? $this->Anomaly_V2 : null;
    }
    /**
     * Set Anomaly_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V2[] $anomaly_V2
     * @return \ArrayType\ArrayOfAnomaly_V2
     */
    public function setAnomaly_V2(array $anomaly_V2 = array())
    {
        foreach ($anomaly_V2 as $arrayOfAnomaly_V2Anomaly_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfAnomaly_V2Anomaly_V2Item instanceof \StructType\Anomaly_V2) {
                throw new \InvalidArgumentException(sprintf('The Anomaly_V2 property can only contain items of \StructType\Anomaly_V2, "%s" given', is_object($arrayOfAnomaly_V2Anomaly_V2Item) ? get_class($arrayOfAnomaly_V2Anomaly_V2Item) : gettype($arrayOfAnomaly_V2Anomaly_V2Item)), __LINE__);
            }
        }
        if (is_null($anomaly_V2) || (is_array($anomaly_V2) && empty($anomaly_V2))) {
            unset($this->Anomaly_V2);
        } else {
            $this->Anomaly_V2 = $anomaly_V2;
        }
        return $this;
    }
    /**
     * Add item to Anomaly_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V2 $item
     * @return \ArrayType\ArrayOfAnomaly_V2
     */
    public function addToAnomaly_V2(\StructType\Anomaly_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anomaly_V2) {
            throw new \InvalidArgumentException(sprintf('The Anomaly_V2 property can only contain items of \StructType\Anomaly_V2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Anomaly_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Anomaly_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Anomaly_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Anomaly_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Anomaly_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Anomaly_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Anomaly_V2
     */
    public function getAttributeName()
    {
        return 'Anomaly_V2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAnomaly_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
