<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAbsenceItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfAbsenceItem extends AbstractStructArrayBase
{
    /**
     * The AbsenceItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AbsenceItem[]
     */
    public $AbsenceItem;
    /**
     * Constructor method for ArrayOfAbsenceItem
     * @uses ArrayOfAbsenceItem::setAbsenceItem()
     * @param \StructType\AbsenceItem[] $absenceItem
     */
    public function __construct(array $absenceItem = array())
    {
        $this
            ->setAbsenceItem($absenceItem);
    }
    /**
     * Get AbsenceItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AbsenceItem[]|null
     */
    public function getAbsenceItem()
    {
        return isset($this->AbsenceItem) ? $this->AbsenceItem : null;
    }
    /**
     * Set AbsenceItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AbsenceItem[] $absenceItem
     * @return \ArrayType\ArrayOfAbsenceItem
     */
    public function setAbsenceItem(array $absenceItem = array())
    {
        foreach ($absenceItem as $arrayOfAbsenceItemAbsenceItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAbsenceItemAbsenceItemItem instanceof \StructType\AbsenceItem) {
                throw new \InvalidArgumentException(sprintf('The AbsenceItem property can only contain items of \StructType\AbsenceItem, "%s" given', is_object($arrayOfAbsenceItemAbsenceItemItem) ? get_class($arrayOfAbsenceItemAbsenceItemItem) : gettype($arrayOfAbsenceItemAbsenceItemItem)), __LINE__);
            }
        }
        if (is_null($absenceItem) || (is_array($absenceItem) && empty($absenceItem))) {
            unset($this->AbsenceItem);
        } else {
            $this->AbsenceItem = $absenceItem;
        }
        return $this;
    }
    /**
     * Add item to AbsenceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AbsenceItem $item
     * @return \ArrayType\ArrayOfAbsenceItem
     */
    public function addToAbsenceItem(\StructType\AbsenceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AbsenceItem) {
            throw new \InvalidArgumentException(sprintf('The AbsenceItem property can only contain items of \StructType\AbsenceItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AbsenceItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AbsenceItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AbsenceItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AbsenceItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AbsenceItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AbsenceItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AbsenceItem
     */
    public function getAttributeName()
    {
        return 'AbsenceItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAbsenceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
