<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAbsence ArrayType
 * @subpackage Arrays
 */
class ArrayOfAbsence extends AbstractStructArrayBase
{
    /**
     * The Absence
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Absence[]
     */
    public $Absence;
    /**
     * Constructor method for ArrayOfAbsence
     * @uses ArrayOfAbsence::setAbsence()
     * @param \StructType\Absence[] $absence
     */
    public function __construct(array $absence = array())
    {
        $this
            ->setAbsence($absence);
    }
    /**
     * Get Absence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Absence[]|null
     */
    public function getAbsence()
    {
        return isset($this->Absence) ? $this->Absence : null;
    }
    /**
     * Set Absence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Absence[] $absence
     * @return \ArrayType\ArrayOfAbsence
     */
    public function setAbsence(array $absence = array())
    {
        foreach ($absence as $arrayOfAbsenceAbsenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfAbsenceAbsenceItem instanceof \StructType\Absence) {
                throw new \InvalidArgumentException(sprintf('The Absence property can only contain items of \StructType\Absence, "%s" given', is_object($arrayOfAbsenceAbsenceItem) ? get_class($arrayOfAbsenceAbsenceItem) : gettype($arrayOfAbsenceAbsenceItem)), __LINE__);
            }
        }
        if (is_null($absence) || (is_array($absence) && empty($absence))) {
            unset($this->Absence);
        } else {
            $this->Absence = $absence;
        }
        return $this;
    }
    /**
     * Add item to Absence value
     * @throws \InvalidArgumentException
     * @param \StructType\Absence $item
     * @return \ArrayType\ArrayOfAbsence
     */
    public function addToAbsence(\StructType\Absence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Absence) {
            throw new \InvalidArgumentException(sprintf('The Absence property can only contain items of \StructType\Absence, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Absence[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Absence|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Absence|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Absence|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Absence|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Absence|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Absence
     */
    public function getAttributeName()
    {
        return 'Absence';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAbsence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
