<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderLine StructType
 * @subpackage Structs
 */
class ECommerceOrderLine extends AbstractStructBase
{
    /**
     * The LineNo
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNo;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The ItemNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ItemNo;
    /**
     * The VariantCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VariantCode;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Quantity;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UnitPrice;
    /**
     * The AmountIncludingVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AmountIncludingVAT;
    /**
     * The SalesSourceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesSourceType;
    /**
     * The SalesType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DiscountAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountAmount;
    /**
     * The SalesUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesUserID;
    /**
     * The ECommerceCampaignCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ECommerceCampaignCode;
    /**
     * The FastDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FastDelivery;
    /**
     * The ECommerceOrderLineDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ECommerceOrderLineDiscount[]
     */
    public $ECommerceOrderLineDiscount;
    /**
     * Constructor method for ECommerceOrderLine
     * @uses ECommerceOrderLine::setLineNo()
     * @uses ECommerceOrderLine::setType()
     * @uses ECommerceOrderLine::setItemNo()
     * @uses ECommerceOrderLine::setVariantCode()
     * @uses ECommerceOrderLine::setQuantity()
     * @uses ECommerceOrderLine::setUnitPrice()
     * @uses ECommerceOrderLine::setAmountIncludingVAT()
     * @uses ECommerceOrderLine::setSalesSourceType()
     * @uses ECommerceOrderLine::setSalesType()
     * @uses ECommerceOrderLine::setDescription()
     * @uses ECommerceOrderLine::setDiscountAmount()
     * @uses ECommerceOrderLine::setSalesUserID()
     * @uses ECommerceOrderLine::setECommerceCampaignCode()
     * @uses ECommerceOrderLine::setFastDelivery()
     * @uses ECommerceOrderLine::setECommerceOrderLineDiscount()
     * @param int $lineNo
     * @param string $type
     * @param string $itemNo
     * @param string $variantCode
     * @param string $quantity
     * @param string $unitPrice
     * @param string $amountIncludingVAT
     * @param string $salesSourceType
     * @param string $salesType
     * @param string $description
     * @param string $discountAmount
     * @param string $salesUserID
     * @param string $eCommerceCampaignCode
     * @param string $fastDelivery
     * @param \StructType\ECommerceOrderLineDiscount[] $eCommerceOrderLineDiscount
     */
    public function __construct($lineNo = 0, $type = null, $itemNo = null, $variantCode = null, $quantity = null, $unitPrice = null, $amountIncludingVAT = null, $salesSourceType = null, $salesType = null, $description = null, $discountAmount = null, $salesUserID = null, $eCommerceCampaignCode = null, $fastDelivery = null, array $eCommerceOrderLineDiscount = array())
    {
        $this
            ->setLineNo($lineNo)
            ->setType($type)
            ->setItemNo($itemNo)
            ->setVariantCode($variantCode)
            ->setQuantity($quantity)
            ->setUnitPrice($unitPrice)
            ->setAmountIncludingVAT($amountIncludingVAT)
            ->setSalesSourceType($salesSourceType)
            ->setSalesType($salesType)
            ->setDescription($description)
            ->setDiscountAmount($discountAmount)
            ->setSalesUserID($salesUserID)
            ->setECommerceCampaignCode($eCommerceCampaignCode)
            ->setFastDelivery($fastDelivery)
            ->setECommerceOrderLineDiscount($eCommerceOrderLineDiscount);
    }
    /**
     * Get LineNo value
     * @return int
     */
    public function getLineNo()
    {
        return $this->LineNo;
    }
    /**
     * Set LineNo value
     * @param int $lineNo
     * @return \StructType\ECommerceOrderLine
     */
    public function setLineNo($lineNo = 0)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !is_numeric($lineNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNo)), __LINE__);
        }
        $this->LineNo = $lineNo;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ECommerceOrderLine
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ItemNo value
     * @return string
     */
    public function getItemNo()
    {
        return $this->ItemNo;
    }
    /**
     * Set ItemNo value
     * @param string $itemNo
     * @return \StructType\ECommerceOrderLine
     */
    public function setItemNo($itemNo = null)
    {
        // validation for constraint: string
        if (!is_null($itemNo) && !is_string($itemNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemNo)), __LINE__);
        }
        $this->ItemNo = $itemNo;
        return $this;
    }
    /**
     * Get VariantCode value
     * @return string
     */
    public function getVariantCode()
    {
        return $this->VariantCode;
    }
    /**
     * Set VariantCode value
     * @param string $variantCode
     * @return \StructType\ECommerceOrderLine
     */
    public function setVariantCode($variantCode = null)
    {
        // validation for constraint: string
        if (!is_null($variantCode) && !is_string($variantCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variantCode)), __LINE__);
        }
        $this->VariantCode = $variantCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\ECommerceOrderLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \StructType\ECommerceOrderLine
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get AmountIncludingVAT value
     * @return string
     */
    public function getAmountIncludingVAT()
    {
        return $this->AmountIncludingVAT;
    }
    /**
     * Set AmountIncludingVAT value
     * @param string $amountIncludingVAT
     * @return \StructType\ECommerceOrderLine
     */
    public function setAmountIncludingVAT($amountIncludingVAT = null)
    {
        // validation for constraint: string
        if (!is_null($amountIncludingVAT) && !is_string($amountIncludingVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amountIncludingVAT)), __LINE__);
        }
        $this->AmountIncludingVAT = $amountIncludingVAT;
        return $this;
    }
    /**
     * Get SalesSourceType value
     * @return string
     */
    public function getSalesSourceType()
    {
        return $this->SalesSourceType;
    }
    /**
     * Set SalesSourceType value
     * @param string $salesSourceType
     * @return \StructType\ECommerceOrderLine
     */
    public function setSalesSourceType($salesSourceType = null)
    {
        // validation for constraint: string
        if (!is_null($salesSourceType) && !is_string($salesSourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesSourceType)), __LINE__);
        }
        $this->SalesSourceType = $salesSourceType;
        return $this;
    }
    /**
     * Get SalesType value
     * @return string
     */
    public function getSalesType()
    {
        return $this->SalesType;
    }
    /**
     * Set SalesType value
     * @param string $salesType
     * @return \StructType\ECommerceOrderLine
     */
    public function setSalesType($salesType = null)
    {
        // validation for constraint: string
        if (!is_null($salesType) && !is_string($salesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesType)), __LINE__);
        }
        $this->SalesType = $salesType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ECommerceOrderLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param string $discountAmount
     * @return \StructType\ECommerceOrderLine
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: string
        if (!is_null($discountAmount) && !is_string($discountAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get SalesUserID value
     * @return string|null
     */
    public function getSalesUserID()
    {
        return $this->SalesUserID;
    }
    /**
     * Set SalesUserID value
     * @param string $salesUserID
     * @return \StructType\ECommerceOrderLine
     */
    public function setSalesUserID($salesUserID = null)
    {
        // validation for constraint: string
        if (!is_null($salesUserID) && !is_string($salesUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesUserID)), __LINE__);
        }
        $this->SalesUserID = $salesUserID;
        return $this;
    }
    /**
     * Get ECommerceCampaignCode value
     * @return string|null
     */
    public function getECommerceCampaignCode()
    {
        return $this->ECommerceCampaignCode;
    }
    /**
     * Set ECommerceCampaignCode value
     * @param string $eCommerceCampaignCode
     * @return \StructType\ECommerceOrderLine
     */
    public function setECommerceCampaignCode($eCommerceCampaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($eCommerceCampaignCode) && !is_string($eCommerceCampaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eCommerceCampaignCode)), __LINE__);
        }
        $this->ECommerceCampaignCode = $eCommerceCampaignCode;
        return $this;
    }
    /**
     * Get FastDelivery value
     * @return string|null
     */
    public function getFastDelivery()
    {
        return $this->FastDelivery;
    }
    /**
     * Set FastDelivery value
     * @param string $fastDelivery
     * @return \StructType\ECommerceOrderLine
     */
    public function setFastDelivery($fastDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($fastDelivery) && !is_string($fastDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fastDelivery)), __LINE__);
        }
        $this->FastDelivery = $fastDelivery;
        return $this;
    }
    /**
     * Get ECommerceOrderLineDiscount value
     * @return \StructType\ECommerceOrderLineDiscount[]|null
     */
    public function getECommerceOrderLineDiscount()
    {
        return $this->ECommerceOrderLineDiscount;
    }
    /**
     * Set ECommerceOrderLineDiscount value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderLineDiscount[] $eCommerceOrderLineDiscount
     * @return \StructType\ECommerceOrderLine
     */
    public function setECommerceOrderLineDiscount(array $eCommerceOrderLineDiscount = array())
    {
        foreach ($eCommerceOrderLineDiscount as $eCommerceOrderLineECommerceOrderLineDiscountItem) {
            // validation for constraint: itemType
            if (!$eCommerceOrderLineECommerceOrderLineDiscountItem instanceof \StructType\ECommerceOrderLineDiscount) {
                throw new \InvalidArgumentException(sprintf('The ECommerceOrderLineDiscount property can only contain items of \StructType\ECommerceOrderLineDiscount, "%s" given', is_object($eCommerceOrderLineECommerceOrderLineDiscountItem) ? get_class($eCommerceOrderLineECommerceOrderLineDiscountItem) : gettype($eCommerceOrderLineECommerceOrderLineDiscountItem)), __LINE__);
            }
        }
        $this->ECommerceOrderLineDiscount = $eCommerceOrderLineDiscount;
        return $this;
    }
    /**
     * Add item to ECommerceOrderLineDiscount value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderLineDiscount $item
     * @return \StructType\ECommerceOrderLine
     */
    public function addToECommerceOrderLineDiscount(\StructType\ECommerceOrderLineDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ECommerceOrderLineDiscount) {
            throw new \InvalidArgumentException(sprintf('The ECommerceOrderLineDiscount property can only contain items of \StructType\ECommerceOrderLineDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ECommerceOrderLineDiscount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
