<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderFunctionLine StructType
 * @subpackage Structs
 */
class ECommerceOrderFunctionLine extends AbstractStructBase
{
    /**
     * The LineNo
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNo;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * The ReturnReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnReasonCode;
    /**
     * The ReturnReasonDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnReasonDescription;
    /**
     * Constructor method for ECommerceOrderFunctionLine
     * @uses ECommerceOrderFunctionLine::setLineNo()
     * @uses ECommerceOrderFunctionLine::setQuantity()
     * @uses ECommerceOrderFunctionLine::setReturnReasonCode()
     * @uses ECommerceOrderFunctionLine::setReturnReasonDescription()
     * @param int $lineNo
     * @param string $quantity
     * @param string $returnReasonCode
     * @param string $returnReasonDescription
     */
    public function __construct($lineNo = 0, $quantity = null, $returnReasonCode = null, $returnReasonDescription = null)
    {
        $this
            ->setLineNo($lineNo)
            ->setQuantity($quantity)
            ->setReturnReasonCode($returnReasonCode)
            ->setReturnReasonDescription($returnReasonDescription);
    }
    /**
     * Get LineNo value
     * @return int
     */
    public function getLineNo()
    {
        return $this->LineNo;
    }
    /**
     * Set LineNo value
     * @param int $lineNo
     * @return \StructType\ECommerceOrderFunctionLine
     */
    public function setLineNo($lineNo = 0)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !is_numeric($lineNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNo)), __LINE__);
        }
        $this->LineNo = $lineNo;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\ECommerceOrderFunctionLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnReasonCode value
     * @return string|null
     */
    public function getReturnReasonCode()
    {
        return $this->ReturnReasonCode;
    }
    /**
     * Set ReturnReasonCode value
     * @param string $returnReasonCode
     * @return \StructType\ECommerceOrderFunctionLine
     */
    public function setReturnReasonCode($returnReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($returnReasonCode) && !is_string($returnReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnReasonCode)), __LINE__);
        }
        $this->ReturnReasonCode = $returnReasonCode;
        return $this;
    }
    /**
     * Get ReturnReasonDescription value
     * @return string|null
     */
    public function getReturnReasonDescription()
    {
        return $this->ReturnReasonDescription;
    }
    /**
     * Set ReturnReasonDescription value
     * @param string $returnReasonDescription
     * @return \StructType\ECommerceOrderFunctionLine
     */
    public function setReturnReasonDescription($returnReasonDescription = null)
    {
        // validation for constraint: string
        if (!is_null($returnReasonDescription) && !is_string($returnReasonDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnReasonDescription)), __LINE__);
        }
        $this->ReturnReasonDescription = $returnReasonDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderFunctionLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
