<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderPayment StructType
 * @subpackage Structs
 */
class ECommerceOrderPayment extends AbstractStructBase
{
    /**
     * The PaymentMethodCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentMethodCode;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Amount;
    /**
     * The InstallmentPeriod
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InstallmentPeriod;
    /**
     * The InstallmentInterestRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallmentInterestRate;
    /**
     * The InstallmentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallmentAmount;
    /**
     * The AuthCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthCode;
    /**
     * The AuthDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthDateTime;
    /**
     * The AuthPostingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthPostingDate;
    /**
     * The PaymentReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentReferenceNumber;
    /**
     * Constructor method for ECommerceOrderPayment
     * @uses ECommerceOrderPayment::setPaymentMethodCode()
     * @uses ECommerceOrderPayment::setAmount()
     * @uses ECommerceOrderPayment::setInstallmentPeriod()
     * @uses ECommerceOrderPayment::setInstallmentInterestRate()
     * @uses ECommerceOrderPayment::setInstallmentAmount()
     * @uses ECommerceOrderPayment::setAuthCode()
     * @uses ECommerceOrderPayment::setAuthDateTime()
     * @uses ECommerceOrderPayment::setAuthPostingDate()
     * @uses ECommerceOrderPayment::setPaymentReferenceNumber()
     * @param string $paymentMethodCode
     * @param string $amount
     * @param int $installmentPeriod
     * @param string $installmentInterestRate
     * @param string $installmentAmount
     * @param string $authCode
     * @param string $authDateTime
     * @param string $authPostingDate
     * @param string $paymentReferenceNumber
     */
    public function __construct($paymentMethodCode = null, $amount = null, $installmentPeriod = 0, $installmentInterestRate = null, $installmentAmount = null, $authCode = null, $authDateTime = null, $authPostingDate = null, $paymentReferenceNumber = null)
    {
        $this
            ->setPaymentMethodCode($paymentMethodCode)
            ->setAmount($amount)
            ->setInstallmentPeriod($installmentPeriod)
            ->setInstallmentInterestRate($installmentInterestRate)
            ->setInstallmentAmount($installmentAmount)
            ->setAuthCode($authCode)
            ->setAuthDateTime($authDateTime)
            ->setAuthPostingDate($authPostingDate)
            ->setPaymentReferenceNumber($paymentReferenceNumber);
    }
    /**
     * Get PaymentMethodCode value
     * @return string
     */
    public function getPaymentMethodCode()
    {
        return $this->PaymentMethodCode;
    }
    /**
     * Set PaymentMethodCode value
     * @param string $paymentMethodCode
     * @return \StructType\ECommerceOrderPayment
     */
    public function setPaymentMethodCode($paymentMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodCode) && !is_string($paymentMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethodCode)), __LINE__);
        }
        $this->PaymentMethodCode = $paymentMethodCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\ECommerceOrderPayment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get InstallmentPeriod value
     * @return int
     */
    public function getInstallmentPeriod()
    {
        return $this->InstallmentPeriod;
    }
    /**
     * Set InstallmentPeriod value
     * @param int $installmentPeriod
     * @return \StructType\ECommerceOrderPayment
     */
    public function setInstallmentPeriod($installmentPeriod = 0)
    {
        // validation for constraint: int
        if (!is_null($installmentPeriod) && !is_numeric($installmentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($installmentPeriod)), __LINE__);
        }
        $this->InstallmentPeriod = $installmentPeriod;
        return $this;
    }
    /**
     * Get InstallmentInterestRate value
     * @return string
     */
    public function getInstallmentInterestRate()
    {
        return $this->InstallmentInterestRate;
    }
    /**
     * Set InstallmentInterestRate value
     * @param string $installmentInterestRate
     * @return \StructType\ECommerceOrderPayment
     */
    public function setInstallmentInterestRate($installmentInterestRate = null)
    {
        // validation for constraint: string
        if (!is_null($installmentInterestRate) && !is_string($installmentInterestRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installmentInterestRate)), __LINE__);
        }
        $this->InstallmentInterestRate = $installmentInterestRate;
        return $this;
    }
    /**
     * Get InstallmentAmount value
     * @return string
     */
    public function getInstallmentAmount()
    {
        return $this->InstallmentAmount;
    }
    /**
     * Set InstallmentAmount value
     * @param string $installmentAmount
     * @return \StructType\ECommerceOrderPayment
     */
    public function setInstallmentAmount($installmentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($installmentAmount) && !is_string($installmentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installmentAmount)), __LINE__);
        }
        $this->InstallmentAmount = $installmentAmount;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\ECommerceOrderPayment
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get AuthDateTime value
     * @return string
     */
    public function getAuthDateTime()
    {
        return $this->AuthDateTime;
    }
    /**
     * Set AuthDateTime value
     * @param string $authDateTime
     * @return \StructType\ECommerceOrderPayment
     */
    public function setAuthDateTime($authDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($authDateTime) && !is_string($authDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authDateTime)), __LINE__);
        }
        $this->AuthDateTime = $authDateTime;
        return $this;
    }
    /**
     * Get AuthPostingDate value
     * @return string
     */
    public function getAuthPostingDate()
    {
        return $this->AuthPostingDate;
    }
    /**
     * Set AuthPostingDate value
     * @param string $authPostingDate
     * @return \StructType\ECommerceOrderPayment
     */
    public function setAuthPostingDate($authPostingDate = null)
    {
        // validation for constraint: string
        if (!is_null($authPostingDate) && !is_string($authPostingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPostingDate)), __LINE__);
        }
        $this->AuthPostingDate = $authPostingDate;
        return $this;
    }
    /**
     * Get PaymentReferenceNumber value
     * @return string
     */
    public function getPaymentReferenceNumber()
    {
        return $this->PaymentReferenceNumber;
    }
    /**
     * Set PaymentReferenceNumber value
     * @param string $paymentReferenceNumber
     * @return \StructType\ECommerceOrderPayment
     */
    public function setPaymentReferenceNumber($paymentReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReferenceNumber) && !is_string($paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentReferenceNumber)), __LINE__);
        }
        $this->PaymentReferenceNumber = $paymentReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
