<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderLineDiscount StructType
 * @subpackage Structs
 */
class ECommerceOrderLineDiscount extends AbstractStructBase
{
    /**
     * The DiscountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DiscountType;
    /**
     * The DiscountID
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DiscountID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for ECommerceOrderLineDiscount
     * @uses ECommerceOrderLineDiscount::setDiscountType()
     * @uses ECommerceOrderLineDiscount::setDiscountID()
     * @uses ECommerceOrderLineDiscount::setAmount()
     * @param string $discountType
     * @param int $discountID
     * @param string $amount
     */
    public function __construct($discountType = null, $discountID = 0, $amount = null)
    {
        $this
            ->setDiscountType($discountType)
            ->setDiscountID($discountID)
            ->setAmount($amount);
    }
    /**
     * Get DiscountType value
     * @return string
     */
    public function getDiscountType()
    {
        return $this->DiscountType;
    }
    /**
     * Set DiscountType value
     * @param string $discountType
     * @return \StructType\ECommerceOrderLineDiscount
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: string
        if (!is_null($discountType) && !is_string($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountType)), __LINE__);
        }
        $this->DiscountType = $discountType;
        return $this;
    }
    /**
     * Get DiscountID value
     * @return int
     */
    public function getDiscountID()
    {
        return $this->DiscountID;
    }
    /**
     * Set DiscountID value
     * @param int $discountID
     * @return \StructType\ECommerceOrderLineDiscount
     */
    public function setDiscountID($discountID = 0)
    {
        // validation for constraint: int
        if (!is_null($discountID) && !is_numeric($discountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($discountID)), __LINE__);
        }
        $this->DiscountID = $discountID;
        return $this;
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\ECommerceOrderLineDiscount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderLineDiscount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
