<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderHeader StructType
 * @subpackage Structs
 */
class ECommerceOrderHeader extends AbstractStructBase
{
    /**
     * The No_
     */
    public $No_;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderType;
    /**
     * The SelltoCustomerNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelltoCustomerNo;
    /**
     * The ShiptoAddressCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShiptoAddressCode;
    /**
     * The BilltoAddressCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BilltoAddressCode;
    /**
     * The ShipInvoiceDocumentTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ShipInvoiceDocumentTo;
    /**
     * The ExtSystemCreationDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExtSystemCreationDateTime;
    /**
     * The SalesType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesType;
    /**
     * The SelltoPhoneNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelltoPhoneNo;
    /**
     * The ECommerceOrderLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ECommerceOrderLine[]
     */
    public $ECommerceOrderLine;
    /**
     * The ECommerceOrderPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ECommerceOrderPayment[]
     */
    public $ECommerceOrderPayment;
    /**
     * The DeliveryNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNotes;
    /**
     * The ExpectedShipmentEndingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedShipmentEndingDate;
    /**
     * The EComCampaignCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EComCampaignCode;
    /**
     * The ShippingAgentAddressCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingAgentAddressCode;
    /**
     * The BillToCustomerNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillToCustomerNo;
    /**
     * The BilltoCustNoBilltoCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BilltoCustNoBilltoCode;
    /**
     * Constructor method for ECommerceOrderHeader
     * @uses ECommerceOrderHeader::setNo_()
     * @uses ECommerceOrderHeader::setOrderType()
     * @uses ECommerceOrderHeader::setSelltoCustomerNo()
     * @uses ECommerceOrderHeader::setShiptoAddressCode()
     * @uses ECommerceOrderHeader::setBilltoAddressCode()
     * @uses ECommerceOrderHeader::setShipInvoiceDocumentTo()
     * @uses ECommerceOrderHeader::setExtSystemCreationDateTime()
     * @uses ECommerceOrderHeader::setSalesType()
     * @uses ECommerceOrderHeader::setSelltoPhoneNo()
     * @uses ECommerceOrderHeader::setECommerceOrderLine()
     * @uses ECommerceOrderHeader::setECommerceOrderPayment()
     * @uses ECommerceOrderHeader::setDeliveryNotes()
     * @uses ECommerceOrderHeader::setExpectedShipmentEndingDate()
     * @uses ECommerceOrderHeader::setEComCampaignCode()
     * @uses ECommerceOrderHeader::setShippingAgentAddressCode()
     * @uses ECommerceOrderHeader::setBillToCustomerNo()
     * @uses ECommerceOrderHeader::setBilltoCustNoBilltoCode()
     * @param string $no_
     * @param string $orderType
     * @param string $selltoCustomerNo
     * @param string $shiptoAddressCode
     * @param string $billtoAddressCode
     * @param string $shipInvoiceDocumentTo
     * @param string $extSystemCreationDateTime
     * @param string $salesType
     * @param string $selltoPhoneNo
     * @param \StructType\ECommerceOrderLine[] $eCommerceOrderLine
     * @param \StructType\ECommerceOrderPayment[] $eCommerceOrderPayment
     * @param string $deliveryNotes
     * @param string $expectedShipmentEndingDate
     * @param string $eComCampaignCode
     * @param string $shippingAgentAddressCode
     * @param string $billToCustomerNo
     * @param string $billtoCustNoBilltoCode
     */
    public function __construct($no_ = null, $orderType = null, $selltoCustomerNo = null, $shiptoAddressCode = null, $billtoAddressCode = null, $shipInvoiceDocumentTo = null, $extSystemCreationDateTime = null, $salesType = null, $selltoPhoneNo = null, array $eCommerceOrderLine = array(), array $eCommerceOrderPayment = array(), $deliveryNotes = null, $expectedShipmentEndingDate = null, $eComCampaignCode = null, $shippingAgentAddressCode = null, $billToCustomerNo = null, $billtoCustNoBilltoCode = null)
    {
        $this
            ->setNo_($no_)
            ->setOrderType($orderType)
            ->setSelltoCustomerNo($selltoCustomerNo)
            ->setShiptoAddressCode($shiptoAddressCode)
            ->setBilltoAddressCode($billtoAddressCode)
            ->setShipInvoiceDocumentTo($shipInvoiceDocumentTo)
            ->setExtSystemCreationDateTime($extSystemCreationDateTime)
            ->setSalesType($salesType)
            ->setSelltoPhoneNo($selltoPhoneNo)
            ->setECommerceOrderLine($eCommerceOrderLine)
            ->setECommerceOrderPayment($eCommerceOrderPayment)
            ->setDeliveryNotes($deliveryNotes)
            ->setExpectedShipmentEndingDate($expectedShipmentEndingDate)
            ->setEComCampaignCode($eComCampaignCode)
            ->setShippingAgentAddressCode($shippingAgentAddressCode)
            ->setBillToCustomerNo($billToCustomerNo)
            ->setBilltoCustNoBilltoCode($billtoCustNoBilltoCode);
    }
    /**
     * Get no_ value
     * @return no_
     */
    public function getNo_()
    {
        return $this->{'No.'};
    }
    /**
     * Set no_ value
     * @param no_ $no_
     * @return \StructType\ECommerceOrderHeader
     */
    public function setNo_($no_ = null)
    {
        // validation for constraint: string
        if (!is_null($no_) && !is_string($no_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($no_)), __LINE__);
        }
        $this->No_ = $this->{'No.'} = $no_;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \StructType\ECommerceOrderHeader
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderType)), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get SelltoCustomerNo value
     * @return string
     */
    public function getSelltoCustomerNo()
    {
        return $this->SelltoCustomerNo;
    }
    /**
     * Set SelltoCustomerNo value
     * @param string $selltoCustomerNo
     * @return \StructType\ECommerceOrderHeader
     */
    public function setSelltoCustomerNo($selltoCustomerNo = null)
    {
        // validation for constraint: string
        if (!is_null($selltoCustomerNo) && !is_string($selltoCustomerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selltoCustomerNo)), __LINE__);
        }
        $this->SelltoCustomerNo = $selltoCustomerNo;
        return $this;
    }
    /**
     * Get ShiptoAddressCode value
     * @return string
     */
    public function getShiptoAddressCode()
    {
        return $this->ShiptoAddressCode;
    }
    /**
     * Set ShiptoAddressCode value
     * @param string $shiptoAddressCode
     * @return \StructType\ECommerceOrderHeader
     */
    public function setShiptoAddressCode($shiptoAddressCode = null)
    {
        // validation for constraint: string
        if (!is_null($shiptoAddressCode) && !is_string($shiptoAddressCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shiptoAddressCode)), __LINE__);
        }
        $this->ShiptoAddressCode = $shiptoAddressCode;
        return $this;
    }
    /**
     * Get BilltoAddressCode value
     * @return string
     */
    public function getBilltoAddressCode()
    {
        return $this->BilltoAddressCode;
    }
    /**
     * Set BilltoAddressCode value
     * @param string $billtoAddressCode
     * @return \StructType\ECommerceOrderHeader
     */
    public function setBilltoAddressCode($billtoAddressCode = null)
    {
        // validation for constraint: string
        if (!is_null($billtoAddressCode) && !is_string($billtoAddressCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billtoAddressCode)), __LINE__);
        }
        $this->BilltoAddressCode = $billtoAddressCode;
        return $this;
    }
    /**
     * Get ShipInvoiceDocumentTo value
     * @return string
     */
    public function getShipInvoiceDocumentTo()
    {
        return $this->ShipInvoiceDocumentTo;
    }
    /**
     * Set ShipInvoiceDocumentTo value
     * @param string $shipInvoiceDocumentTo
     * @return \StructType\ECommerceOrderHeader
     */
    public function setShipInvoiceDocumentTo($shipInvoiceDocumentTo = null)
    {
        // validation for constraint: string
        if (!is_null($shipInvoiceDocumentTo) && !is_string($shipInvoiceDocumentTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipInvoiceDocumentTo)), __LINE__);
        }
        $this->ShipInvoiceDocumentTo = $shipInvoiceDocumentTo;
        return $this;
    }
    /**
     * Get ExtSystemCreationDateTime value
     * @return string
     */
    public function getExtSystemCreationDateTime()
    {
        return $this->ExtSystemCreationDateTime;
    }
    /**
     * Set ExtSystemCreationDateTime value
     * @param string $extSystemCreationDateTime
     * @return \StructType\ECommerceOrderHeader
     */
    public function setExtSystemCreationDateTime($extSystemCreationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($extSystemCreationDateTime) && !is_string($extSystemCreationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extSystemCreationDateTime)), __LINE__);
        }
        $this->ExtSystemCreationDateTime = $extSystemCreationDateTime;
        return $this;
    }
    /**
     * Get SalesType value
     * @return string
     */
    public function getSalesType()
    {
        return $this->SalesType;
    }
    /**
     * Set SalesType value
     * @param string $salesType
     * @return \StructType\ECommerceOrderHeader
     */
    public function setSalesType($salesType = null)
    {
        // validation for constraint: string
        if (!is_null($salesType) && !is_string($salesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesType)), __LINE__);
        }
        $this->SalesType = $salesType;
        return $this;
    }
    /**
     * Get SelltoPhoneNo value
     * @return string
     */
    public function getSelltoPhoneNo()
    {
        return $this->SelltoPhoneNo;
    }
    /**
     * Set SelltoPhoneNo value
     * @param string $selltoPhoneNo
     * @return \StructType\ECommerceOrderHeader
     */
    public function setSelltoPhoneNo($selltoPhoneNo = null)
    {
        // validation for constraint: string
        if (!is_null($selltoPhoneNo) && !is_string($selltoPhoneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selltoPhoneNo)), __LINE__);
        }
        $this->SelltoPhoneNo = $selltoPhoneNo;
        return $this;
    }
    /**
     * Get ECommerceOrderLine value
     * @return \StructType\ECommerceOrderLine[]
     */
    public function getECommerceOrderLine()
    {
        return $this->ECommerceOrderLine;
    }
    /**
     * Set ECommerceOrderLine value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderLine[] $eCommerceOrderLine
     * @return \StructType\ECommerceOrderHeader
     */
    public function setECommerceOrderLine(array $eCommerceOrderLine = array())
    {
        foreach ($eCommerceOrderLine as $eCommerceOrderHeaderECommerceOrderLineItem) {
            // validation for constraint: itemType
            if (!$eCommerceOrderHeaderECommerceOrderLineItem instanceof \StructType\ECommerceOrderLine) {
                throw new \InvalidArgumentException(sprintf('The ECommerceOrderLine property can only contain items of \StructType\ECommerceOrderLine, "%s" given', is_object($eCommerceOrderHeaderECommerceOrderLineItem) ? get_class($eCommerceOrderHeaderECommerceOrderLineItem) : gettype($eCommerceOrderHeaderECommerceOrderLineItem)), __LINE__);
            }
        }
        $this->ECommerceOrderLine = $eCommerceOrderLine;
        return $this;
    }
    /**
     * Add item to ECommerceOrderLine value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderLine $item
     * @return \StructType\ECommerceOrderHeader
     */
    public function addToECommerceOrderLine(\StructType\ECommerceOrderLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ECommerceOrderLine) {
            throw new \InvalidArgumentException(sprintf('The ECommerceOrderLine property can only contain items of \StructType\ECommerceOrderLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ECommerceOrderLine[] = $item;
        return $this;
    }
    /**
     * Get ECommerceOrderPayment value
     * @return \StructType\ECommerceOrderPayment[]
     */
    public function getECommerceOrderPayment()
    {
        return $this->ECommerceOrderPayment;
    }
    /**
     * Set ECommerceOrderPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderPayment[] $eCommerceOrderPayment
     * @return \StructType\ECommerceOrderHeader
     */
    public function setECommerceOrderPayment(array $eCommerceOrderPayment = array())
    {
        foreach ($eCommerceOrderPayment as $eCommerceOrderHeaderECommerceOrderPaymentItem) {
            // validation for constraint: itemType
            if (!$eCommerceOrderHeaderECommerceOrderPaymentItem instanceof \StructType\ECommerceOrderPayment) {
                throw new \InvalidArgumentException(sprintf('The ECommerceOrderPayment property can only contain items of \StructType\ECommerceOrderPayment, "%s" given', is_object($eCommerceOrderHeaderECommerceOrderPaymentItem) ? get_class($eCommerceOrderHeaderECommerceOrderPaymentItem) : gettype($eCommerceOrderHeaderECommerceOrderPaymentItem)), __LINE__);
            }
        }
        $this->ECommerceOrderPayment = $eCommerceOrderPayment;
        return $this;
    }
    /**
     * Add item to ECommerceOrderPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderPayment $item
     * @return \StructType\ECommerceOrderHeader
     */
    public function addToECommerceOrderPayment(\StructType\ECommerceOrderPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ECommerceOrderPayment) {
            throw new \InvalidArgumentException(sprintf('The ECommerceOrderPayment property can only contain items of \StructType\ECommerceOrderPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ECommerceOrderPayment[] = $item;
        return $this;
    }
    /**
     * Get DeliveryNotes value
     * @return string|null
     */
    public function getDeliveryNotes()
    {
        return $this->DeliveryNotes;
    }
    /**
     * Set DeliveryNotes value
     * @param string $deliveryNotes
     * @return \StructType\ECommerceOrderHeader
     */
    public function setDeliveryNotes($deliveryNotes = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNotes) && !is_string($deliveryNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryNotes)), __LINE__);
        }
        $this->DeliveryNotes = $deliveryNotes;
        return $this;
    }
    /**
     * Get ExpectedShipmentEndingDate value
     * @return string|null
     */
    public function getExpectedShipmentEndingDate()
    {
        return $this->ExpectedShipmentEndingDate;
    }
    /**
     * Set ExpectedShipmentEndingDate value
     * @param string $expectedShipmentEndingDate
     * @return \StructType\ECommerceOrderHeader
     */
    public function setExpectedShipmentEndingDate($expectedShipmentEndingDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedShipmentEndingDate) && !is_string($expectedShipmentEndingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedShipmentEndingDate)), __LINE__);
        }
        $this->ExpectedShipmentEndingDate = $expectedShipmentEndingDate;
        return $this;
    }
    /**
     * Get EComCampaignCode value
     * @return string|null
     */
    public function getEComCampaignCode()
    {
        return $this->EComCampaignCode;
    }
    /**
     * Set EComCampaignCode value
     * @param string $eComCampaignCode
     * @return \StructType\ECommerceOrderHeader
     */
    public function setEComCampaignCode($eComCampaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($eComCampaignCode) && !is_string($eComCampaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eComCampaignCode)), __LINE__);
        }
        $this->EComCampaignCode = $eComCampaignCode;
        return $this;
    }
    /**
     * Get ShippingAgentAddressCode value
     * @return string|null
     */
    public function getShippingAgentAddressCode()
    {
        return $this->ShippingAgentAddressCode;
    }
    /**
     * Set ShippingAgentAddressCode value
     * @param string $shippingAgentAddressCode
     * @return \StructType\ECommerceOrderHeader
     */
    public function setShippingAgentAddressCode($shippingAgentAddressCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingAgentAddressCode) && !is_string($shippingAgentAddressCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingAgentAddressCode)), __LINE__);
        }
        $this->ShippingAgentAddressCode = $shippingAgentAddressCode;
        return $this;
    }
    /**
     * Get BillToCustomerNo value
     * @return string|null
     */
    public function getBillToCustomerNo()
    {
        return $this->BillToCustomerNo;
    }
    /**
     * Set BillToCustomerNo value
     * @param string $billToCustomerNo
     * @return \StructType\ECommerceOrderHeader
     */
    public function setBillToCustomerNo($billToCustomerNo = null)
    {
        // validation for constraint: string
        if (!is_null($billToCustomerNo) && !is_string($billToCustomerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billToCustomerNo)), __LINE__);
        }
        $this->BillToCustomerNo = $billToCustomerNo;
        return $this;
    }
    /**
     * Get BilltoCustNoBilltoCode value
     * @return string|null
     */
    public function getBilltoCustNoBilltoCode()
    {
        return $this->BilltoCustNoBilltoCode;
    }
    /**
     * Set BilltoCustNoBilltoCode value
     * @param string $billtoCustNoBilltoCode
     * @return \StructType\ECommerceOrderHeader
     */
    public function setBilltoCustNoBilltoCode($billtoCustNoBilltoCode = null)
    {
        // validation for constraint: string
        if (!is_null($billtoCustNoBilltoCode) && !is_string($billtoCustNoBilltoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billtoCustNoBilltoCode)), __LINE__);
        }
        $this->BilltoCustNoBilltoCode = $billtoCustNoBilltoCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
