<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECommerceOrderFunctionHeader StructType
 * @subpackage Structs
 */
class ECommerceOrderFunctionHeader extends AbstractStructBase
{
    /**
     * The ECommerceOrderNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ECommerceOrderNo;
    /**
     * The FunctionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FunctionType;
    /**
     * The CancellationReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancellationReasonCode;
    /**
     * The ThirdPartyShptPostingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyShptPostingDate;
    /**
     * The ThirdPartyShptExtDocNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyShptExtDocNo;
    /**
     * The ECommerceOrderFunctionLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ECommerceOrderFunctionLine[]
     */
    public $ECommerceOrderFunctionLine;
    /**
     * Constructor method for ECommerceOrderFunctionHeader
     * @uses ECommerceOrderFunctionHeader::setECommerceOrderNo()
     * @uses ECommerceOrderFunctionHeader::setFunctionType()
     * @uses ECommerceOrderFunctionHeader::setCancellationReasonCode()
     * @uses ECommerceOrderFunctionHeader::setThirdPartyShptPostingDate()
     * @uses ECommerceOrderFunctionHeader::setThirdPartyShptExtDocNo()
     * @uses ECommerceOrderFunctionHeader::setECommerceOrderFunctionLine()
     * @param string $eCommerceOrderNo
     * @param string $functionType
     * @param string $cancellationReasonCode
     * @param string $thirdPartyShptPostingDate
     * @param string $thirdPartyShptExtDocNo
     * @param \StructType\ECommerceOrderFunctionLine[] $eCommerceOrderFunctionLine
     */
    public function __construct($eCommerceOrderNo = null, $functionType = null, $cancellationReasonCode = null, $thirdPartyShptPostingDate = null, $thirdPartyShptExtDocNo = null, array $eCommerceOrderFunctionLine = array())
    {
        $this
            ->setECommerceOrderNo($eCommerceOrderNo)
            ->setFunctionType($functionType)
            ->setCancellationReasonCode($cancellationReasonCode)
            ->setThirdPartyShptPostingDate($thirdPartyShptPostingDate)
            ->setThirdPartyShptExtDocNo($thirdPartyShptExtDocNo)
            ->setECommerceOrderFunctionLine($eCommerceOrderFunctionLine);
    }
    /**
     * Get ECommerceOrderNo value
     * @return string
     */
    public function getECommerceOrderNo()
    {
        return $this->ECommerceOrderNo;
    }
    /**
     * Set ECommerceOrderNo value
     * @param string $eCommerceOrderNo
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setECommerceOrderNo($eCommerceOrderNo = null)
    {
        // validation for constraint: string
        if (!is_null($eCommerceOrderNo) && !is_string($eCommerceOrderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eCommerceOrderNo)), __LINE__);
        }
        $this->ECommerceOrderNo = $eCommerceOrderNo;
        return $this;
    }
    /**
     * Get FunctionType value
     * @return string
     */
    public function getFunctionType()
    {
        return $this->FunctionType;
    }
    /**
     * Set FunctionType value
     * @param string $functionType
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setFunctionType($functionType = null)
    {
        // validation for constraint: string
        if (!is_null($functionType) && !is_string($functionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($functionType)), __LINE__);
        }
        $this->FunctionType = $functionType;
        return $this;
    }
    /**
     * Get CancellationReasonCode value
     * @return string|null
     */
    public function getCancellationReasonCode()
    {
        return $this->CancellationReasonCode;
    }
    /**
     * Set CancellationReasonCode value
     * @param string $cancellationReasonCode
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setCancellationReasonCode($cancellationReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReasonCode) && !is_string($cancellationReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cancellationReasonCode)), __LINE__);
        }
        $this->CancellationReasonCode = $cancellationReasonCode;
        return $this;
    }
    /**
     * Get ThirdPartyShptPostingDate value
     * @return string|null
     */
    public function getThirdPartyShptPostingDate()
    {
        return $this->ThirdPartyShptPostingDate;
    }
    /**
     * Set ThirdPartyShptPostingDate value
     * @param string $thirdPartyShptPostingDate
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setThirdPartyShptPostingDate($thirdPartyShptPostingDate = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyShptPostingDate) && !is_string($thirdPartyShptPostingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyShptPostingDate)), __LINE__);
        }
        $this->ThirdPartyShptPostingDate = $thirdPartyShptPostingDate;
        return $this;
    }
    /**
     * Get ThirdPartyShptExtDocNo value
     * @return string|null
     */
    public function getThirdPartyShptExtDocNo()
    {
        return $this->ThirdPartyShptExtDocNo;
    }
    /**
     * Set ThirdPartyShptExtDocNo value
     * @param string $thirdPartyShptExtDocNo
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setThirdPartyShptExtDocNo($thirdPartyShptExtDocNo = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyShptExtDocNo) && !is_string($thirdPartyShptExtDocNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyShptExtDocNo)), __LINE__);
        }
        $this->ThirdPartyShptExtDocNo = $thirdPartyShptExtDocNo;
        return $this;
    }
    /**
     * Get ECommerceOrderFunctionLine value
     * @return \StructType\ECommerceOrderFunctionLine[]|null
     */
    public function getECommerceOrderFunctionLine()
    {
        return $this->ECommerceOrderFunctionLine;
    }
    /**
     * Set ECommerceOrderFunctionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderFunctionLine[] $eCommerceOrderFunctionLine
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function setECommerceOrderFunctionLine(array $eCommerceOrderFunctionLine = array())
    {
        foreach ($eCommerceOrderFunctionLine as $eCommerceOrderFunctionHeaderECommerceOrderFunctionLineItem) {
            // validation for constraint: itemType
            if (!$eCommerceOrderFunctionHeaderECommerceOrderFunctionLineItem instanceof \StructType\ECommerceOrderFunctionLine) {
                throw new \InvalidArgumentException(sprintf('The ECommerceOrderFunctionLine property can only contain items of \StructType\ECommerceOrderFunctionLine, "%s" given', is_object($eCommerceOrderFunctionHeaderECommerceOrderFunctionLineItem) ? get_class($eCommerceOrderFunctionHeaderECommerceOrderFunctionLineItem) : gettype($eCommerceOrderFunctionHeaderECommerceOrderFunctionLineItem)), __LINE__);
            }
        }
        $this->ECommerceOrderFunctionLine = $eCommerceOrderFunctionLine;
        return $this;
    }
    /**
     * Add item to ECommerceOrderFunctionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\ECommerceOrderFunctionLine $item
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public function addToECommerceOrderFunctionLine(\StructType\ECommerceOrderFunctionLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ECommerceOrderFunctionLine) {
            throw new \InvalidArgumentException(sprintf('The ECommerceOrderFunctionLine property can only contain items of \StructType\ECommerceOrderFunctionLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ECommerceOrderFunctionLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ECommerceOrderFunctionHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
