<?php

namespace EnumType;

/**
 * This class stands for TypeTaalcode EnumType
 * @subpackage Enumerations
 */
class TypeTaalcode
{
    /**
     * Constant for value 'de'
     * @return string 'de'
     */
    const VALUE_DE = 'de';
    /**
     * Constant for value 'en'
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'it'
     * @return string 'it'
     */
    const VALUE_IT = 'it';
    /**
     * Constant for value 'nl'
     * @return string 'nl'
     */
    const VALUE_NL = 'nl';
    /**
     * Constant for value 'pt'
     * @return string 'pt'
     */
    const VALUE_PT = 'pt';
    /**
     * Constant for value 'es'
     * @return string 'es'
     */
    const VALUE_ES = 'es';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DE
     * @uses self::VALUE_EN
     * @uses self::VALUE_FR
     * @uses self::VALUE_IT
     * @uses self::VALUE_NL
     * @uses self::VALUE_PT
     * @uses self::VALUE_ES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DE,
            self::VALUE_EN,
            self::VALUE_FR,
            self::VALUE_IT,
            self::VALUE_NL,
            self::VALUE_PT,
            self::VALUE_ES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
