<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tabela StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Tabela
 * @subpackage Structs
 */
class Tabela extends AbstractStructBase
{
    /**
     * The Comando
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comando;
    /**
     * The Registros
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRegistros
     */
    public $Registros;
    /**
     * Constructor method for Tabela
     * @uses Tabela::setComando()
     * @uses Tabela::setRegistros()
     * @param string $comando
     * @param \ArrayType\ArrayOfRegistros $registros
     */
    public function __construct($comando = null, \ArrayType\ArrayOfRegistros $registros = null)
    {
        $this
            ->setComando($comando)
            ->setRegistros($registros);
    }
    /**
     * Get Comando value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComando()
    {
        return isset($this->Comando) ? $this->Comando : null;
    }
    /**
     * Set Comando value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comando
     * @return \StructType\Tabela
     */
    public function setComando($comando = null)
    {
        // validation for constraint: string
        if (!is_null($comando) && !is_string($comando)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comando)), __LINE__);
        }
        if (is_null($comando) || (is_array($comando) && empty($comando))) {
            unset($this->Comando);
        } else {
            $this->Comando = $comando;
        }
        return $this;
    }
    /**
     * Get Registros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRegistros|null
     */
    public function getRegistros()
    {
        return isset($this->Registros) ? $this->Registros : null;
    }
    /**
     * Set Registros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRegistros $registros
     * @return \StructType\Tabela
     */
    public function setRegistros(\ArrayType\ArrayOfRegistros $registros = null)
    {
        if (is_null($registros) || (is_array($registros) && empty($registros))) {
            unset($this->Registros);
        } else {
            $this->Registros = $registros;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tabela
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
