<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegistros ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRegistros
 * @subpackage Arrays
 */
class ArrayOfRegistros extends AbstractStructArrayBase
{
    /**
     * The Registros
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Registros[]
     */
    public $Registros;
    /**
     * Constructor method for ArrayOfRegistros
     * @uses ArrayOfRegistros::setRegistros()
     * @param \StructType\Registros[] $registros
     */
    public function __construct(array $registros = array())
    {
        $this
            ->setRegistros($registros);
    }
    /**
     * Get Registros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Registros[]|null
     */
    public function getRegistros()
    {
        return isset($this->Registros) ? $this->Registros : null;
    }
    /**
     * Set Registros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Registros[] $registros
     * @return \ArrayType\ArrayOfRegistros
     */
    public function setRegistros(array $registros = array())
    {
        foreach ($registros as $arrayOfRegistrosRegistrosItem) {
            // validation for constraint: itemType
            if (!$arrayOfRegistrosRegistrosItem instanceof \StructType\Registros) {
                throw new \InvalidArgumentException(sprintf('The Registros property can only contain items of \StructType\Registros, "%s" given', is_object($arrayOfRegistrosRegistrosItem) ? get_class($arrayOfRegistrosRegistrosItem) : gettype($arrayOfRegistrosRegistrosItem)), __LINE__);
            }
        }
        if (is_null($registros) || (is_array($registros) && empty($registros))) {
            unset($this->Registros);
        } else {
            $this->Registros = $registros;
        }
        return $this;
    }
    /**
     * Add item to Registros value
     * @throws \InvalidArgumentException
     * @param \StructType\Registros $item
     * @return \ArrayType\ArrayOfRegistros
     */
    public function addToRegistros(\StructType\Registros $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Registros) {
            throw new \InvalidArgumentException(sprintf('The Registros property can only contain items of \StructType\Registros, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Registros[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Registros|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Registros|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Registros|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Registros|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Registros|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Registros
     */
    public function getAttributeName()
    {
        return 'Registros';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRegistros
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
