<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommandParameter ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCommandParameter
 * @subpackage Arrays
 */
class ArrayOfCommandParameter extends AbstractStructArrayBase
{
    /**
     * The CommandParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CommandParameter[]
     */
    public $CommandParameter;
    /**
     * Constructor method for ArrayOfCommandParameter
     * @uses ArrayOfCommandParameter::setCommandParameter()
     * @param \StructType\CommandParameter[] $commandParameter
     */
    public function __construct(array $commandParameter = array())
    {
        $this
            ->setCommandParameter($commandParameter);
    }
    /**
     * Get CommandParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CommandParameter[]|null
     */
    public function getCommandParameter()
    {
        return isset($this->CommandParameter) ? $this->CommandParameter : null;
    }
    /**
     * Set CommandParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommandParameter[] $commandParameter
     * @return \ArrayType\ArrayOfCommandParameter
     */
    public function setCommandParameter(array $commandParameter = array())
    {
        foreach ($commandParameter as $arrayOfCommandParameterCommandParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommandParameterCommandParameterItem instanceof \StructType\CommandParameter) {
                throw new \InvalidArgumentException(sprintf('The CommandParameter property can only contain items of \StructType\CommandParameter, "%s" given', is_object($arrayOfCommandParameterCommandParameterItem) ? get_class($arrayOfCommandParameterCommandParameterItem) : gettype($arrayOfCommandParameterCommandParameterItem)), __LINE__);
            }
        }
        if (is_null($commandParameter) || (is_array($commandParameter) && empty($commandParameter))) {
            unset($this->CommandParameter);
        } else {
            $this->CommandParameter = $commandParameter;
        }
        return $this;
    }
    /**
     * Add item to CommandParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\CommandParameter $item
     * @return \ArrayType\ArrayOfCommandParameter
     */
    public function addToCommandParameter(\StructType\CommandParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommandParameter) {
            throw new \InvalidArgumentException(sprintf('The CommandParameter property can only contain items of \StructType\CommandParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommandParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CommandParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CommandParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CommandParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CommandParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CommandParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommandParameter
     */
    public function getAttributeName()
    {
        return 'CommandParameter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCommandParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
