<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://consultant.viktech.test.axp.dk/waiter.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://consultant.viktech.test.axp.dk/waiter.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\ExternalApis\ConsendoAxp\Soap\ClassMap::get(),
);
/**
 * Samples for Adjust ServiceType
 */
$adjust = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Adjust($options);
/**
 * Sample call for adjustOrderTimesheet operation/method
 */
if ($adjust->adjustOrderTimesheet($handle, $temp_label, $order_id, $title, $comment, $shift_data) !== false) {
    print_r($adjust->getResult());
} else {
    print_r($adjust->getLastError());
}
/**
 * Samples for Version ServiceType
 */
$version = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Version($options);
/**
 * Sample call for version operation/method
 */
if ($version->version() !== false) {
    print_r($version->getResult());
} else {
    print_r($version->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Get($options);
/**
 * Sample call for getHandle operation/method
 */
if ($get->getHandle($username, $password) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomer operation/method
 */
if ($get->getCustomer($handle, $cust_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContact operation/method
 */
if ($get->getContact($handle, $uid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getC5ProjectList operation/method
 */
if ($get->getC5ProjectList($handle, $date) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getC5ArchivedProjectList operation/method
 */
if ($get->getC5ArchivedProjectList($handle, $date) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpCustomerRawList operation/method
 */
if ($get->getAxpCustomerRawList($handle, $company, $company_id_from, $company_id_to, $created_before, $created_after, $internal_id_from, $internal_id_to) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpCustIdFromCustNo operation/method
 */
if ($get->getAxpCustIdFromCustNo($handle, $cust_no) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpCustomerContactList operation/method
 */
if ($get->getAxpCustomerContactList($handle, $cust_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpBusinessAreaList operation/method
 */
if ($get->getAxpBusinessAreaList($handle, $baids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpDepartmentList operation/method
 */
if ($get->getAxpDepartmentList($handle, $dids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpErpSegmentList operation/method
 */
if ($get->getAxpErpSegmentList($handle, $esids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpPersonalInterestList operation/method
 */
if ($get->getAxpPersonalInterestList($handle, $piids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getErpGuestDataList operation/method
 */
if ($get->getErpGuestDataList($handle, $fieldIds) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpActivityTypeList operation/method
 */
if ($get->getAxpActivityTypeList($handle, $aids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpFieldOfWorkList operation/method
 */
if ($get->getAxpFieldOfWorkList($handle, $fids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpCompanyFormList operation/method
 */
if ($get->getAxpCompanyFormList($handle, $cfids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpTempRawList operation/method
 */
if ($get->getAxpTempRawList($handle, $tids, $label, $classifications, $created_before, $created_after, $cpr, $baids, $updated_before, $updated_after) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpTidFromLabel operation/method
 */
if ($get->getAxpTidFromLabel($handle, $label) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpTempSkillList operation/method
 */
if ($get->getAxpTempSkillList($handle, $tid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpTempBizareaList operation/method
 */
if ($get->getAxpTempBizareaList($handle, $tid) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpConsultantList operation/method
 */
if ($get->getAxpConsultantList($handle) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpCustomerGroupList operation/method
 */
if ($get->getAxpCustomerGroupList($handle, $cgids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpOrderList operation/method
 */
if ($get->getAxpOrderList($handle, $orids, $company, $cust_no) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpOridFromOrderId operation/method
 */
if ($get->getAxpOridFromOrderId($handle, $order_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpOrderTempList operation/method
 */
if ($get->getAxpOrderTempList($handle, $orids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpOrderLineList operation/method
 */
if ($get->getAxpOrderLineList($handle, $olids, $orids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpContractList operation/method
 */
if ($get->getAxpContractList($handle, $cids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpBookings operation/method
 */
if ($get->getAxpBookings($handle, $from_date, $to_date) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpAreas operation/method
 */
if ($get->getAxpAreas($handle, $aids) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpNotes operation/method
 */
if ($get->getAxpNotes($handle) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAxpNationalities operation/method
 */
if ($get->getAxpNationalities($handle) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Create($options);
/**
 * Sample call for createCustomer operation/method
 */
if ($create->createCustomer($handle, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, new \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString(), $notes, $partners_agreement, $partners_agreement_end, $customergroup_id) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createContact operation/method
 */
if ($create->createContact($handle, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAxpCustomer operation/method
 */
if ($create->createAxpCustomer($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAxpCustomerContact operation/method
 */
if ($create->createAxpCustomerContact($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAxpTempOrder operation/method
 */
if ($create->createAxpTempOrder($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Update($options);
/**
 * Sample call for updateCustomer operation/method
 */
if ($update->updateCustomer($handle, $cust_id, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, new \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString(), $notes, $partners_agreement, $partners_agreement_end, $customergroup_id) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateContact operation/method
 */
if ($update->updateContact($handle, $uid, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAxpCustomer operation/method
 */
if ($update->updateAxpCustomer($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAxpCustomerContact operation/method
 */
if ($update->updateAxpCustomerContact($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAxpTempOrder operation/method
 */
if ($update->updateAxpTempOrder($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder(), $orid) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAxpTempClassification operation/method
 */
if ($update->updateAxpTempClassification($handle, $tid, $classification) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Upload($options);
/**
 * Sample call for uploadOneCandidate operation/method
 */
if ($upload->uploadOneCandidate($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTemp(), $documentList, $AxpTempBizareasList, $AxpTempHistList, $AxpTempSkillsList, $AxpTempAnnotationList, $AxpTempEduList, $geoAreas) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Clock ServiceType
 */
$clock = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Clock($options);
/**
 * Sample call for clockStampclock operation/method
 */
if ($clock->clockStampclock($handle, $data) !== false) {
    print_r($clock->getResult());
} else {
    print_r($clock->getLastError());
}
/**
 * Samples for Remote ServiceType
 */
$remote = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Remote($options);
/**
 * Sample call for remoteDataDump operation/method
 */
if ($remote->remoteDataDump($handle) !== false) {
    print_r($remote->getResult());
} else {
    print_r($remote->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Book($options);
/**
 * Sample call for bookTempOnShift operation/method
 */
if ($book->bookTempOnShift($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Sample call for bookTempOnOrder operation/method
 */
if ($book->bookTempOnOrder($handle, $orid, $tid, $from_date, $to_date) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Extend ServiceType
 */
$extend = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Extend($options);
/**
 * Sample call for extendAxpTempOrder operation/method
 */
if ($extend->extendAxpTempOrder($handle, $orid, $from_date, $to_date, $tids) !== false) {
    print_r($extend->getResult());
} else {
    print_r($extend->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Archive($options);
/**
 * Sample call for archiveTempOrder operation/method
 */
if ($archive->archiveTempOrder($handle, $orid, $reason, $remarks) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Complete($options);
/**
 * Sample call for completeAxpTempOrder operation/method
 */
if ($complete->completeAxpTempOrder($handle, $orid, $create_auto_activities) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Import($options);
/**
 * Sample call for importBridgeTemp operation/method
 */
if ($import->importBridgeTemp($handle, new \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw(), $operationType) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importBridgeCalendar operation/method
 */
if ($import->importBridgeCalendar($handle, $cpr, $from, $to, $kind, $remarks) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Delete($options);
/**
 * Sample call for deleteBridgeCalendar operation/method
 */
if ($delete->deleteBridgeCalendar($handle, $cpr, $from) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Approve ServiceType
 */
$approve = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Approve($options);
/**
 * Sample call for approveWeekAsCustomer operation/method
 */
if ($approve->approveWeekAsCustomer($handle, $monday, $orid, $tid) !== false) {
    print_r($approve->getResult());
} else {
    print_r($approve->getLastError());
}
/**
 * Sample call for approveWeekAsTemp operation/method
 */
if ($approve->approveWeekAsTemp($handle, $monday, $orid, $tid) !== false) {
    print_r($approve->getResult());
} else {
    print_r($approve->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Check($options);
/**
 * Sample call for checkLogin operation/method
 */
if ($check->checkLogin($handle, $username, $password) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Debug ServiceType
 */
$debug = new \App\ExternalApis\ConsendoAxp\Soap\ServiceType\Debug($options);
/**
 * Sample call for debug operation/method
 */
if ($debug->debug($data) !== false) {
    print_r($debug->getResult());
} else {
    print_r($debug->getLastError());
}
