<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The fileName
     * @var string
     */
    public $fileName;
    /**
     * The fileDescription
     * @var string
     */
    public $fileDescription;
    /**
     * The fileContent
     * @var string
     */
    public $fileContent;
    /**
     * Constructor method for document
     * @uses Document::setFileName()
     * @uses Document::setFileDescription()
     * @uses Document::setFileContent()
     * @param string $fileName
     * @param string $fileDescription
     * @param string $fileContent
     */
    public function __construct($fileName = null, $fileDescription = null, $fileContent = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileDescription($fileDescription)
            ->setFileContent($fileContent);
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Document
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileDescription value
     * @return string|null
     */
    public function getFileDescription()
    {
        return $this->fileDescription;
    }
    /**
     * Set fileDescription value
     * @param string $fileDescription
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Document
     */
    public function setFileDescription($fileDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fileDescription) && !is_string($fileDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileDescription)), __LINE__);
        }
        $this->fileDescription = $fileDescription;
        return $this;
    }
    /**
     * Get fileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->fileContent;
    }
    /**
     * Set fileContent value
     * @param string $fileContent
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Document
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileContent)), __LINE__);
        }
        $this->fileContent = $fileContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
