<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpOrder StructType
 * @subpackage Structs
 */
class AxpOrder extends AbstractStructBase
{
    /**
     * The orid
     * @var int
     */
    public $orid;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The order_id
     * @var string
     */
    public $order_id;
    /**
     * The cid
     * @var int
     */
    public $cid;
    /**
     * The cust_id
     * @var int
     */
    public $cust_id;
    /**
     * The ccid
     * @var int
     */
    public $ccid;
    /**
     * The did
     * @var int
     */
    public $did;
    /**
     * The received
     * @var string
     */
    public $received;
    /**
     * The bizarea
     * @var int
     */
    public $bizarea;
    /**
     * The location
     * @var int
     */
    public $location;
    /**
     * The from_date
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * @var string
     */
    public $to_date;
    /**
     * The billing_ccid
     * @var int
     */
    public $billing_ccid;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The from_time
     * @var string
     */
    public $from_time;
    /**
     * The to_time
     * @var string
     */
    public $to_time;
    /**
     * The first_time
     * @var string
     */
    public $first_time;
    /**
     * The friday_time
     * @var string
     */
    public $friday_time;
    /**
     * The canrate
     * @var bool
     */
    public $canrate;
    /**
     * The work_oral
     * @var bool
     */
    public $work_oral;
    /**
     * The work_printout
     * @var bool
     */
    public $work_printout;
    /**
     * The billing_oral
     * @var bool
     */
    public $billing_oral;
    /**
     * The billing_printout
     * @var bool
     */
    public $billing_printout;
    /**
     * The discount
     * @var float
     */
    public $discount;
    /**
     * The cost_factor
     * @var float
     */
    public $cost_factor;
    /**
     * The flags
     * @var int
     */
    public $flags;
    /**
     * The reference
     * @var string
     */
    public $reference;
    /**
     * The items_per_page
     * @var int
     */
    public $items_per_page;
    /**
     * The order_key
     * @var string
     */
    public $order_key;
    /**
     * The use_order_key
     * @var bool
     */
    public $use_order_key;
    /**
     * The order_type
     * @var int
     */
    public $order_type;
    /**
     * The recruitment_salary
     * @var float
     */
    public $recruitment_salary;
    /**
     * The recruitment_percentage
     * @var float
     */
    public $recruitment_percentage;
    /**
     * The recruitment_price
     * @var float
     */
    public $recruitment_price;
    /**
     * The contract
     * @var int
     */
    public $contract;
    /**
     * The contract_mod
     * @var int
     */
    public $contract_mod;
    /**
     * The planned_break
     * @var float
     */
    public $planned_break;
    /**
     * The agreement_aid
     * @var int
     */
    public $agreement_aid;
    /**
     * The advertise
     * @var bool
     */
    public $advertise;
    /**
     * The recruitment_reference
     * @var string
     */
    public $recruitment_reference;
    /**
     * The efaktura_ean_invoice
     * @var string
     */
    public $efaktura_ean_invoice;
    /**
     * The efaktura_ean_delivery
     * @var string
     */
    public $efaktura_ean_delivery;
    /**
     * The efaktura_orderno
     * @var string
     */
    public $efaktura_orderno;
    /**
     * The efaktura_account
     * @var string
     */
    public $efaktura_account;
    /**
     * The ean_can_ignore
     * @var bool
     */
    public $ean_can_ignore;
    /**
     * The payment_customer
     * @var int
     */
    public $payment_customer;
    /**
     * The expected_invoicing_month
     * @var string
     */
    public $expected_invoicing_month;
    /**
     * The required_temps
     * @var int
     */
    public $required_temps;
    /**
     * The nominal_hours
     * @var float
     */
    public $nominal_hours;
    /**
     * The recruitment_appls_closed
     * @var bool
     */
    public $recruitment_appls_closed;
    /**
     * The parent
     * @var int
     */
    public $parent;
    /**
     * The selfbooking_template
     * @var int
     */
    public $selfbooking_template;
    /**
     * The manual_location
     * @var string
     */
    public $manual_location;
    /**
     * The manual_address
     * @var string
     */
    public $manual_address;
    /**
     * The manual_zip_city
     * @var string
     */
    public $manual_zip_city;
    /**
     * The manual_transport_info
     * @var string
     */
    public $manual_transport_info;
    /**
     * The manual_area
     * @var int
     */
    public $manual_area;
    /**
     * The manual_phone
     * @var string
     */
    public $manual_phone;
    /**
     * The budget_invoice_price
     * @var float
     */
    public $budget_invoice_price;
    /**
     * The budget_payment_price
     * @var float
     */
    public $budget_payment_price;
    /**
     * The template_name
     * @var string
     */
    public $template_name;
    /**
     * The global_location
     * @var int
     */
    public $global_location;
    /**
     * The status_code
     * @var int
     */
    public $status_code;
    /**
     * The expected_month_coverage
     * @var int
     */
    public $expected_month_coverage;
    /**
     * The expected_coverage
     * @var int
     */
    public $expected_coverage;
    /**
     * The cancellation_reason
     * @var int
     */
    public $cancellation_reason;
    /**
     * The sdid
     * @var int
     */
    public $sdid;
    /**
     * The recruit_start
     * @var string
     */
    public $recruit_start;
    /**
     * The recruit_stop
     * @var string
     */
    public $recruit_stop;
    /**
     * The recruit_consultantholder
     * @var int
     */
    public $recruit_consultantholder;
    /**
     * The matchgroup
     * @var int
     */
    public $matchgroup;
    /**
     * The coaching_statuscode
     * @var int
     */
    public $coaching_statuscode;
    /**
     * The order_identity
     * @var int
     */
    public $order_identity;
    /**
     * The period_type
     * @var int
     */
    public $period_type;
    /**
     * The period_end_day
     * @var int
     */
    public $period_end_day;
    /**
     * The intern_note
     * @var string
     */
    public $intern_note;
    /**
     * The customer_consultant
     * @var int
     */
    public $customer_consultant;
    /**
     * The custom_timesheet_recipient
     * @var int
     */
    public $custom_timesheet_recipient;
    /**
     * The week_input
     * @var string
     */
    public $week_input;
    /**
     * The dont_book_holidays
     * @var bool
     */
    public $dont_book_holidays;
    /**
     * Constructor method for AxpOrder
     * @uses AxpOrder::setOrid()
     * @uses AxpOrder::setStatus()
     * @uses AxpOrder::setOrder_id()
     * @uses AxpOrder::setCid()
     * @uses AxpOrder::setCust_id()
     * @uses AxpOrder::setCcid()
     * @uses AxpOrder::setDid()
     * @uses AxpOrder::setReceived()
     * @uses AxpOrder::setBizarea()
     * @uses AxpOrder::setLocation()
     * @uses AxpOrder::setFrom_date()
     * @uses AxpOrder::setTo_date()
     * @uses AxpOrder::setBilling_ccid()
     * @uses AxpOrder::setDescription()
     * @uses AxpOrder::setFrom_time()
     * @uses AxpOrder::setTo_time()
     * @uses AxpOrder::setFirst_time()
     * @uses AxpOrder::setFriday_time()
     * @uses AxpOrder::setCanrate()
     * @uses AxpOrder::setWork_oral()
     * @uses AxpOrder::setWork_printout()
     * @uses AxpOrder::setBilling_oral()
     * @uses AxpOrder::setBilling_printout()
     * @uses AxpOrder::setDiscount()
     * @uses AxpOrder::setCost_factor()
     * @uses AxpOrder::setFlags()
     * @uses AxpOrder::setReference()
     * @uses AxpOrder::setItems_per_page()
     * @uses AxpOrder::setOrder_key()
     * @uses AxpOrder::setUse_order_key()
     * @uses AxpOrder::setOrder_type()
     * @uses AxpOrder::setRecruitment_salary()
     * @uses AxpOrder::setRecruitment_percentage()
     * @uses AxpOrder::setRecruitment_price()
     * @uses AxpOrder::setContract()
     * @uses AxpOrder::setContract_mod()
     * @uses AxpOrder::setPlanned_break()
     * @uses AxpOrder::setAgreement_aid()
     * @uses AxpOrder::setAdvertise()
     * @uses AxpOrder::setRecruitment_reference()
     * @uses AxpOrder::setEfaktura_ean_invoice()
     * @uses AxpOrder::setEfaktura_ean_delivery()
     * @uses AxpOrder::setEfaktura_orderno()
     * @uses AxpOrder::setEfaktura_account()
     * @uses AxpOrder::setEan_can_ignore()
     * @uses AxpOrder::setPayment_customer()
     * @uses AxpOrder::setExpected_invoicing_month()
     * @uses AxpOrder::setRequired_temps()
     * @uses AxpOrder::setNominal_hours()
     * @uses AxpOrder::setRecruitment_appls_closed()
     * @uses AxpOrder::setParent()
     * @uses AxpOrder::setSelfbooking_template()
     * @uses AxpOrder::setManual_location()
     * @uses AxpOrder::setManual_address()
     * @uses AxpOrder::setManual_zip_city()
     * @uses AxpOrder::setManual_transport_info()
     * @uses AxpOrder::setManual_area()
     * @uses AxpOrder::setManual_phone()
     * @uses AxpOrder::setBudget_invoice_price()
     * @uses AxpOrder::setBudget_payment_price()
     * @uses AxpOrder::setTemplate_name()
     * @uses AxpOrder::setGlobal_location()
     * @uses AxpOrder::setStatus_code()
     * @uses AxpOrder::setExpected_month_coverage()
     * @uses AxpOrder::setExpected_coverage()
     * @uses AxpOrder::setCancellation_reason()
     * @uses AxpOrder::setSdid()
     * @uses AxpOrder::setRecruit_start()
     * @uses AxpOrder::setRecruit_stop()
     * @uses AxpOrder::setRecruit_consultantholder()
     * @uses AxpOrder::setMatchgroup()
     * @uses AxpOrder::setCoaching_statuscode()
     * @uses AxpOrder::setOrder_identity()
     * @uses AxpOrder::setPeriod_type()
     * @uses AxpOrder::setPeriod_end_day()
     * @uses AxpOrder::setIntern_note()
     * @uses AxpOrder::setCustomer_consultant()
     * @uses AxpOrder::setCustom_timesheet_recipient()
     * @uses AxpOrder::setWeek_input()
     * @uses AxpOrder::setDont_book_holidays()
     * @param int $orid
     * @param int $status
     * @param string $order_id
     * @param int $cid
     * @param int $cust_id
     * @param int $ccid
     * @param int $did
     * @param string $received
     * @param int $bizarea
     * @param int $location
     * @param string $from_date
     * @param string $to_date
     * @param int $billing_ccid
     * @param string $description
     * @param string $from_time
     * @param string $to_time
     * @param string $first_time
     * @param string $friday_time
     * @param bool $canrate
     * @param bool $work_oral
     * @param bool $work_printout
     * @param bool $billing_oral
     * @param bool $billing_printout
     * @param float $discount
     * @param float $cost_factor
     * @param int $flags
     * @param string $reference
     * @param int $items_per_page
     * @param string $order_key
     * @param bool $use_order_key
     * @param int $order_type
     * @param float $recruitment_salary
     * @param float $recruitment_percentage
     * @param float $recruitment_price
     * @param int $contract
     * @param int $contract_mod
     * @param float $planned_break
     * @param int $agreement_aid
     * @param bool $advertise
     * @param string $recruitment_reference
     * @param string $efaktura_ean_invoice
     * @param string $efaktura_ean_delivery
     * @param string $efaktura_orderno
     * @param string $efaktura_account
     * @param bool $ean_can_ignore
     * @param int $payment_customer
     * @param string $expected_invoicing_month
     * @param int $required_temps
     * @param float $nominal_hours
     * @param bool $recruitment_appls_closed
     * @param int $parent
     * @param int $selfbooking_template
     * @param string $manual_location
     * @param string $manual_address
     * @param string $manual_zip_city
     * @param string $manual_transport_info
     * @param int $manual_area
     * @param string $manual_phone
     * @param float $budget_invoice_price
     * @param float $budget_payment_price
     * @param string $template_name
     * @param int $global_location
     * @param int $status_code
     * @param int $expected_month_coverage
     * @param int $expected_coverage
     * @param int $cancellation_reason
     * @param int $sdid
     * @param string $recruit_start
     * @param string $recruit_stop
     * @param int $recruit_consultantholder
     * @param int $matchgroup
     * @param int $coaching_statuscode
     * @param int $order_identity
     * @param int $period_type
     * @param int $period_end_day
     * @param string $intern_note
     * @param int $customer_consultant
     * @param int $custom_timesheet_recipient
     * @param string $week_input
     * @param bool $dont_book_holidays
     */
    public function __construct($orid = null, $status = null, $order_id = null, $cid = null, $cust_id = null, $ccid = null, $did = null, $received = null, $bizarea = null, $location = null, $from_date = null, $to_date = null, $billing_ccid = null, $description = null, $from_time = null, $to_time = null, $first_time = null, $friday_time = null, $canrate = null, $work_oral = null, $work_printout = null, $billing_oral = null, $billing_printout = null, $discount = null, $cost_factor = null, $flags = null, $reference = null, $items_per_page = null, $order_key = null, $use_order_key = null, $order_type = null, $recruitment_salary = null, $recruitment_percentage = null, $recruitment_price = null, $contract = null, $contract_mod = null, $planned_break = null, $agreement_aid = null, $advertise = null, $recruitment_reference = null, $efaktura_ean_invoice = null, $efaktura_ean_delivery = null, $efaktura_orderno = null, $efaktura_account = null, $ean_can_ignore = null, $payment_customer = null, $expected_invoicing_month = null, $required_temps = null, $nominal_hours = null, $recruitment_appls_closed = null, $parent = null, $selfbooking_template = null, $manual_location = null, $manual_address = null, $manual_zip_city = null, $manual_transport_info = null, $manual_area = null, $manual_phone = null, $budget_invoice_price = null, $budget_payment_price = null, $template_name = null, $global_location = null, $status_code = null, $expected_month_coverage = null, $expected_coverage = null, $cancellation_reason = null, $sdid = null, $recruit_start = null, $recruit_stop = null, $recruit_consultantholder = null, $matchgroup = null, $coaching_statuscode = null, $order_identity = null, $period_type = null, $period_end_day = null, $intern_note = null, $customer_consultant = null, $custom_timesheet_recipient = null, $week_input = null, $dont_book_holidays = null)
    {
        $this
            ->setOrid($orid)
            ->setStatus($status)
            ->setOrder_id($order_id)
            ->setCid($cid)
            ->setCust_id($cust_id)
            ->setCcid($ccid)
            ->setDid($did)
            ->setReceived($received)
            ->setBizarea($bizarea)
            ->setLocation($location)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setBilling_ccid($billing_ccid)
            ->setDescription($description)
            ->setFrom_time($from_time)
            ->setTo_time($to_time)
            ->setFirst_time($first_time)
            ->setFriday_time($friday_time)
            ->setCanrate($canrate)
            ->setWork_oral($work_oral)
            ->setWork_printout($work_printout)
            ->setBilling_oral($billing_oral)
            ->setBilling_printout($billing_printout)
            ->setDiscount($discount)
            ->setCost_factor($cost_factor)
            ->setFlags($flags)
            ->setReference($reference)
            ->setItems_per_page($items_per_page)
            ->setOrder_key($order_key)
            ->setUse_order_key($use_order_key)
            ->setOrder_type($order_type)
            ->setRecruitment_salary($recruitment_salary)
            ->setRecruitment_percentage($recruitment_percentage)
            ->setRecruitment_price($recruitment_price)
            ->setContract($contract)
            ->setContract_mod($contract_mod)
            ->setPlanned_break($planned_break)
            ->setAgreement_aid($agreement_aid)
            ->setAdvertise($advertise)
            ->setRecruitment_reference($recruitment_reference)
            ->setEfaktura_ean_invoice($efaktura_ean_invoice)
            ->setEfaktura_ean_delivery($efaktura_ean_delivery)
            ->setEfaktura_orderno($efaktura_orderno)
            ->setEfaktura_account($efaktura_account)
            ->setEan_can_ignore($ean_can_ignore)
            ->setPayment_customer($payment_customer)
            ->setExpected_invoicing_month($expected_invoicing_month)
            ->setRequired_temps($required_temps)
            ->setNominal_hours($nominal_hours)
            ->setRecruitment_appls_closed($recruitment_appls_closed)
            ->setParent($parent)
            ->setSelfbooking_template($selfbooking_template)
            ->setManual_location($manual_location)
            ->setManual_address($manual_address)
            ->setManual_zip_city($manual_zip_city)
            ->setManual_transport_info($manual_transport_info)
            ->setManual_area($manual_area)
            ->setManual_phone($manual_phone)
            ->setBudget_invoice_price($budget_invoice_price)
            ->setBudget_payment_price($budget_payment_price)
            ->setTemplate_name($template_name)
            ->setGlobal_location($global_location)
            ->setStatus_code($status_code)
            ->setExpected_month_coverage($expected_month_coverage)
            ->setExpected_coverage($expected_coverage)
            ->setCancellation_reason($cancellation_reason)
            ->setSdid($sdid)
            ->setRecruit_start($recruit_start)
            ->setRecruit_stop($recruit_stop)
            ->setRecruit_consultantholder($recruit_consultantholder)
            ->setMatchgroup($matchgroup)
            ->setCoaching_statuscode($coaching_statuscode)
            ->setOrder_identity($order_identity)
            ->setPeriod_type($period_type)
            ->setPeriod_end_day($period_end_day)
            ->setIntern_note($intern_note)
            ->setCustomer_consultant($customer_consultant)
            ->setCustom_timesheet_recipient($custom_timesheet_recipient)
            ->setWeek_input($week_input)
            ->setDont_book_holidays($dont_book_holidays);
    }
    /**
     * Get orid value
     * @return int|null
     */
    public function getOrid()
    {
        return $this->orid;
    }
    /**
     * Set orid value
     * @param int $orid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setOrid($orid = null)
    {
        // validation for constraint: int
        if (!is_null($orid) && !is_numeric($orid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orid)), __LINE__);
        }
        $this->orid = $orid;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get cid value
     * @return int|null
     */
    public function getCid()
    {
        return $this->cid;
    }
    /**
     * Set cid value
     * @param int $cid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCid($cid = null)
    {
        // validation for constraint: int
        if (!is_null($cid) && !is_numeric($cid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cid)), __LINE__);
        }
        $this->cid = $cid;
        return $this;
    }
    /**
     * Get cust_id value
     * @return int|null
     */
    public function getCust_id()
    {
        return $this->cust_id;
    }
    /**
     * Set cust_id value
     * @param int $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCust_id($cust_id = null)
    {
        // validation for constraint: int
        if (!is_null($cust_id) && !is_numeric($cust_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_id)), __LINE__);
        }
        $this->cust_id = $cust_id;
        return $this;
    }
    /**
     * Get ccid value
     * @return int|null
     */
    public function getCcid()
    {
        return $this->ccid;
    }
    /**
     * Set ccid value
     * @param int $ccid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCcid($ccid = null)
    {
        // validation for constraint: int
        if (!is_null($ccid) && !is_numeric($ccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccid)), __LINE__);
        }
        $this->ccid = $ccid;
        return $this;
    }
    /**
     * Get did value
     * @return int|null
     */
    public function getDid()
    {
        return $this->did;
    }
    /**
     * Set did value
     * @param int $did
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setDid($did = null)
    {
        // validation for constraint: int
        if (!is_null($did) && !is_numeric($did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($did)), __LINE__);
        }
        $this->did = $did;
        return $this;
    }
    /**
     * Get received value
     * @return string|null
     */
    public function getReceived()
    {
        return $this->received;
    }
    /**
     * Set received value
     * @param string $received
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setReceived($received = null)
    {
        // validation for constraint: string
        if (!is_null($received) && !is_string($received)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($received)), __LINE__);
        }
        $this->received = $received;
        return $this;
    }
    /**
     * Get bizarea value
     * @return int|null
     */
    public function getBizarea()
    {
        return $this->bizarea;
    }
    /**
     * Set bizarea value
     * @param int $bizarea
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBizarea($bizarea = null)
    {
        // validation for constraint: int
        if (!is_null($bizarea) && !is_numeric($bizarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bizarea)), __LINE__);
        }
        $this->bizarea = $bizarea;
        return $this;
    }
    /**
     * Get location value
     * @return int|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param int $location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setLocation($location = null)
    {
        // validation for constraint: int
        if (!is_null($location) && !is_numeric($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get from_date value
     * @return string|null
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string|null
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get billing_ccid value
     * @return int|null
     */
    public function getBilling_ccid()
    {
        return $this->billing_ccid;
    }
    /**
     * Set billing_ccid value
     * @param int $billing_ccid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBilling_ccid($billing_ccid = null)
    {
        // validation for constraint: int
        if (!is_null($billing_ccid) && !is_numeric($billing_ccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_ccid)), __LINE__);
        }
        $this->billing_ccid = $billing_ccid;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get from_time value
     * @return string|null
     */
    public function getFrom_time()
    {
        return $this->from_time;
    }
    /**
     * Set from_time value
     * @param string $from_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setFrom_time($from_time = null)
    {
        // validation for constraint: string
        if (!is_null($from_time) && !is_string($from_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_time)), __LINE__);
        }
        $this->from_time = $from_time;
        return $this;
    }
    /**
     * Get to_time value
     * @return string|null
     */
    public function getTo_time()
    {
        return $this->to_time;
    }
    /**
     * Set to_time value
     * @param string $to_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setTo_time($to_time = null)
    {
        // validation for constraint: string
        if (!is_null($to_time) && !is_string($to_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_time)), __LINE__);
        }
        $this->to_time = $to_time;
        return $this;
    }
    /**
     * Get first_time value
     * @return string|null
     */
    public function getFirst_time()
    {
        return $this->first_time;
    }
    /**
     * Set first_time value
     * @param string $first_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setFirst_time($first_time = null)
    {
        // validation for constraint: string
        if (!is_null($first_time) && !is_string($first_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first_time)), __LINE__);
        }
        $this->first_time = $first_time;
        return $this;
    }
    /**
     * Get friday_time value
     * @return string|null
     */
    public function getFriday_time()
    {
        return $this->friday_time;
    }
    /**
     * Set friday_time value
     * @param string $friday_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setFriday_time($friday_time = null)
    {
        // validation for constraint: string
        if (!is_null($friday_time) && !is_string($friday_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($friday_time)), __LINE__);
        }
        $this->friday_time = $friday_time;
        return $this;
    }
    /**
     * Get canrate value
     * @return bool|null
     */
    public function getCanrate()
    {
        return $this->canrate;
    }
    /**
     * Set canrate value
     * @param bool $canrate
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCanrate($canrate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canrate) && !is_bool($canrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canrate)), __LINE__);
        }
        $this->canrate = $canrate;
        return $this;
    }
    /**
     * Get work_oral value
     * @return bool|null
     */
    public function getWork_oral()
    {
        return $this->work_oral;
    }
    /**
     * Set work_oral value
     * @param bool $work_oral
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setWork_oral($work_oral = null)
    {
        // validation for constraint: boolean
        if (!is_null($work_oral) && !is_bool($work_oral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($work_oral)), __LINE__);
        }
        $this->work_oral = $work_oral;
        return $this;
    }
    /**
     * Get work_printout value
     * @return bool|null
     */
    public function getWork_printout()
    {
        return $this->work_printout;
    }
    /**
     * Set work_printout value
     * @param bool $work_printout
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setWork_printout($work_printout = null)
    {
        // validation for constraint: boolean
        if (!is_null($work_printout) && !is_bool($work_printout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($work_printout)), __LINE__);
        }
        $this->work_printout = $work_printout;
        return $this;
    }
    /**
     * Get billing_oral value
     * @return bool|null
     */
    public function getBilling_oral()
    {
        return $this->billing_oral;
    }
    /**
     * Set billing_oral value
     * @param bool $billing_oral
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBilling_oral($billing_oral = null)
    {
        // validation for constraint: boolean
        if (!is_null($billing_oral) && !is_bool($billing_oral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($billing_oral)), __LINE__);
        }
        $this->billing_oral = $billing_oral;
        return $this;
    }
    /**
     * Get billing_printout value
     * @return bool|null
     */
    public function getBilling_printout()
    {
        return $this->billing_printout;
    }
    /**
     * Set billing_printout value
     * @param bool $billing_printout
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBilling_printout($billing_printout = null)
    {
        // validation for constraint: boolean
        if (!is_null($billing_printout) && !is_bool($billing_printout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($billing_printout)), __LINE__);
        }
        $this->billing_printout = $billing_printout;
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setDiscount($discount = null)
    {
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get cost_factor value
     * @return float|null
     */
    public function getCost_factor()
    {
        return $this->cost_factor;
    }
    /**
     * Set cost_factor value
     * @param float $cost_factor
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCost_factor($cost_factor = null)
    {
        $this->cost_factor = $cost_factor;
        return $this;
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !is_numeric($flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get items_per_page value
     * @return int|null
     */
    public function getItems_per_page()
    {
        return $this->items_per_page;
    }
    /**
     * Set items_per_page value
     * @param int $items_per_page
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setItems_per_page($items_per_page = null)
    {
        // validation for constraint: int
        if (!is_null($items_per_page) && !is_numeric($items_per_page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($items_per_page)), __LINE__);
        }
        $this->items_per_page = $items_per_page;
        return $this;
    }
    /**
     * Get order_key value
     * @return string|null
     */
    public function getOrder_key()
    {
        return $this->order_key;
    }
    /**
     * Set order_key value
     * @param string $order_key
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setOrder_key($order_key = null)
    {
        // validation for constraint: string
        if (!is_null($order_key) && !is_string($order_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_key)), __LINE__);
        }
        $this->order_key = $order_key;
        return $this;
    }
    /**
     * Get use_order_key value
     * @return bool|null
     */
    public function getUse_order_key()
    {
        return $this->use_order_key;
    }
    /**
     * Set use_order_key value
     * @param bool $use_order_key
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setUse_order_key($use_order_key = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_order_key) && !is_bool($use_order_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($use_order_key)), __LINE__);
        }
        $this->use_order_key = $use_order_key;
        return $this;
    }
    /**
     * Get order_type value
     * @return int|null
     */
    public function getOrder_type()
    {
        return $this->order_type;
    }
    /**
     * Set order_type value
     * @param int $order_type
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setOrder_type($order_type = null)
    {
        // validation for constraint: int
        if (!is_null($order_type) && !is_numeric($order_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_type)), __LINE__);
        }
        $this->order_type = $order_type;
        return $this;
    }
    /**
     * Get recruitment_salary value
     * @return float|null
     */
    public function getRecruitment_salary()
    {
        return $this->recruitment_salary;
    }
    /**
     * Set recruitment_salary value
     * @param float $recruitment_salary
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruitment_salary($recruitment_salary = null)
    {
        $this->recruitment_salary = $recruitment_salary;
        return $this;
    }
    /**
     * Get recruitment_percentage value
     * @return float|null
     */
    public function getRecruitment_percentage()
    {
        return $this->recruitment_percentage;
    }
    /**
     * Set recruitment_percentage value
     * @param float $recruitment_percentage
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruitment_percentage($recruitment_percentage = null)
    {
        $this->recruitment_percentage = $recruitment_percentage;
        return $this;
    }
    /**
     * Get recruitment_price value
     * @return float|null
     */
    public function getRecruitment_price()
    {
        return $this->recruitment_price;
    }
    /**
     * Set recruitment_price value
     * @param float $recruitment_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruitment_price($recruitment_price = null)
    {
        $this->recruitment_price = $recruitment_price;
        return $this;
    }
    /**
     * Get contract value
     * @return int|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param int $contract
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setContract($contract = null)
    {
        // validation for constraint: int
        if (!is_null($contract) && !is_numeric($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contract)), __LINE__);
        }
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get contract_mod value
     * @return int|null
     */
    public function getContract_mod()
    {
        return $this->contract_mod;
    }
    /**
     * Set contract_mod value
     * @param int $contract_mod
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setContract_mod($contract_mod = null)
    {
        // validation for constraint: int
        if (!is_null($contract_mod) && !is_numeric($contract_mod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contract_mod)), __LINE__);
        }
        $this->contract_mod = $contract_mod;
        return $this;
    }
    /**
     * Get planned_break value
     * @return float|null
     */
    public function getPlanned_break()
    {
        return $this->planned_break;
    }
    /**
     * Set planned_break value
     * @param float $planned_break
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setPlanned_break($planned_break = null)
    {
        $this->planned_break = $planned_break;
        return $this;
    }
    /**
     * Get agreement_aid value
     * @return int|null
     */
    public function getAgreement_aid()
    {
        return $this->agreement_aid;
    }
    /**
     * Set agreement_aid value
     * @param int $agreement_aid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setAgreement_aid($agreement_aid = null)
    {
        // validation for constraint: int
        if (!is_null($agreement_aid) && !is_numeric($agreement_aid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($agreement_aid)), __LINE__);
        }
        $this->agreement_aid = $agreement_aid;
        return $this;
    }
    /**
     * Get advertise value
     * @return bool|null
     */
    public function getAdvertise()
    {
        return $this->advertise;
    }
    /**
     * Set advertise value
     * @param bool $advertise
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setAdvertise($advertise = null)
    {
        // validation for constraint: boolean
        if (!is_null($advertise) && !is_bool($advertise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($advertise)), __LINE__);
        }
        $this->advertise = $advertise;
        return $this;
    }
    /**
     * Get recruitment_reference value
     * @return string|null
     */
    public function getRecruitment_reference()
    {
        return $this->recruitment_reference;
    }
    /**
     * Set recruitment_reference value
     * @param string $recruitment_reference
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruitment_reference($recruitment_reference = null)
    {
        // validation for constraint: string
        if (!is_null($recruitment_reference) && !is_string($recruitment_reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recruitment_reference)), __LINE__);
        }
        $this->recruitment_reference = $recruitment_reference;
        return $this;
    }
    /**
     * Get efaktura_ean_invoice value
     * @return string|null
     */
    public function getEfaktura_ean_invoice()
    {
        return $this->efaktura_ean_invoice;
    }
    /**
     * Set efaktura_ean_invoice value
     * @param string $efaktura_ean_invoice
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setEfaktura_ean_invoice($efaktura_ean_invoice = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_ean_invoice) && !is_string($efaktura_ean_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_ean_invoice)), __LINE__);
        }
        $this->efaktura_ean_invoice = $efaktura_ean_invoice;
        return $this;
    }
    /**
     * Get efaktura_ean_delivery value
     * @return string|null
     */
    public function getEfaktura_ean_delivery()
    {
        return $this->efaktura_ean_delivery;
    }
    /**
     * Set efaktura_ean_delivery value
     * @param string $efaktura_ean_delivery
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setEfaktura_ean_delivery($efaktura_ean_delivery = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_ean_delivery) && !is_string($efaktura_ean_delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_ean_delivery)), __LINE__);
        }
        $this->efaktura_ean_delivery = $efaktura_ean_delivery;
        return $this;
    }
    /**
     * Get efaktura_orderno value
     * @return string|null
     */
    public function getEfaktura_orderno()
    {
        return $this->efaktura_orderno;
    }
    /**
     * Set efaktura_orderno value
     * @param string $efaktura_orderno
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setEfaktura_orderno($efaktura_orderno = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_orderno) && !is_string($efaktura_orderno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_orderno)), __LINE__);
        }
        $this->efaktura_orderno = $efaktura_orderno;
        return $this;
    }
    /**
     * Get efaktura_account value
     * @return string|null
     */
    public function getEfaktura_account()
    {
        return $this->efaktura_account;
    }
    /**
     * Set efaktura_account value
     * @param string $efaktura_account
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setEfaktura_account($efaktura_account = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_account) && !is_string($efaktura_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_account)), __LINE__);
        }
        $this->efaktura_account = $efaktura_account;
        return $this;
    }
    /**
     * Get ean_can_ignore value
     * @return bool|null
     */
    public function getEan_can_ignore()
    {
        return $this->ean_can_ignore;
    }
    /**
     * Set ean_can_ignore value
     * @param bool $ean_can_ignore
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setEan_can_ignore($ean_can_ignore = null)
    {
        // validation for constraint: boolean
        if (!is_null($ean_can_ignore) && !is_bool($ean_can_ignore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ean_can_ignore)), __LINE__);
        }
        $this->ean_can_ignore = $ean_can_ignore;
        return $this;
    }
    /**
     * Get payment_customer value
     * @return int|null
     */
    public function getPayment_customer()
    {
        return $this->payment_customer;
    }
    /**
     * Set payment_customer value
     * @param int $payment_customer
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setPayment_customer($payment_customer = null)
    {
        // validation for constraint: int
        if (!is_null($payment_customer) && !is_numeric($payment_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payment_customer)), __LINE__);
        }
        $this->payment_customer = $payment_customer;
        return $this;
    }
    /**
     * Get expected_invoicing_month value
     * @return string|null
     */
    public function getExpected_invoicing_month()
    {
        return $this->expected_invoicing_month;
    }
    /**
     * Set expected_invoicing_month value
     * @param string $expected_invoicing_month
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setExpected_invoicing_month($expected_invoicing_month = null)
    {
        // validation for constraint: string
        if (!is_null($expected_invoicing_month) && !is_string($expected_invoicing_month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expected_invoicing_month)), __LINE__);
        }
        $this->expected_invoicing_month = $expected_invoicing_month;
        return $this;
    }
    /**
     * Get required_temps value
     * @return int|null
     */
    public function getRequired_temps()
    {
        return $this->required_temps;
    }
    /**
     * Set required_temps value
     * @param int $required_temps
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRequired_temps($required_temps = null)
    {
        // validation for constraint: int
        if (!is_null($required_temps) && !is_numeric($required_temps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($required_temps)), __LINE__);
        }
        $this->required_temps = $required_temps;
        return $this;
    }
    /**
     * Get nominal_hours value
     * @return float|null
     */
    public function getNominal_hours()
    {
        return $this->nominal_hours;
    }
    /**
     * Set nominal_hours value
     * @param float $nominal_hours
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setNominal_hours($nominal_hours = null)
    {
        $this->nominal_hours = $nominal_hours;
        return $this;
    }
    /**
     * Get recruitment_appls_closed value
     * @return bool|null
     */
    public function getRecruitment_appls_closed()
    {
        return $this->recruitment_appls_closed;
    }
    /**
     * Set recruitment_appls_closed value
     * @param bool $recruitment_appls_closed
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruitment_appls_closed($recruitment_appls_closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($recruitment_appls_closed) && !is_bool($recruitment_appls_closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($recruitment_appls_closed)), __LINE__);
        }
        $this->recruitment_appls_closed = $recruitment_appls_closed;
        return $this;
    }
    /**
     * Get parent value
     * @return int|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param int $parent
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setParent($parent = null)
    {
        // validation for constraint: int
        if (!is_null($parent) && !is_numeric($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parent)), __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get selfbooking_template value
     * @return int|null
     */
    public function getSelfbooking_template()
    {
        return $this->selfbooking_template;
    }
    /**
     * Set selfbooking_template value
     * @param int $selfbooking_template
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setSelfbooking_template($selfbooking_template = null)
    {
        // validation for constraint: int
        if (!is_null($selfbooking_template) && !is_numeric($selfbooking_template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($selfbooking_template)), __LINE__);
        }
        $this->selfbooking_template = $selfbooking_template;
        return $this;
    }
    /**
     * Get manual_location value
     * @return string|null
     */
    public function getManual_location()
    {
        return $this->manual_location;
    }
    /**
     * Set manual_location value
     * @param string $manual_location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_location($manual_location = null)
    {
        // validation for constraint: string
        if (!is_null($manual_location) && !is_string($manual_location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_location)), __LINE__);
        }
        $this->manual_location = $manual_location;
        return $this;
    }
    /**
     * Get manual_address value
     * @return string|null
     */
    public function getManual_address()
    {
        return $this->manual_address;
    }
    /**
     * Set manual_address value
     * @param string $manual_address
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_address($manual_address = null)
    {
        // validation for constraint: string
        if (!is_null($manual_address) && !is_string($manual_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_address)), __LINE__);
        }
        $this->manual_address = $manual_address;
        return $this;
    }
    /**
     * Get manual_zip_city value
     * @return string|null
     */
    public function getManual_zip_city()
    {
        return $this->manual_zip_city;
    }
    /**
     * Set manual_zip_city value
     * @param string $manual_zip_city
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_zip_city($manual_zip_city = null)
    {
        // validation for constraint: string
        if (!is_null($manual_zip_city) && !is_string($manual_zip_city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_zip_city)), __LINE__);
        }
        $this->manual_zip_city = $manual_zip_city;
        return $this;
    }
    /**
     * Get manual_transport_info value
     * @return string|null
     */
    public function getManual_transport_info()
    {
        return $this->manual_transport_info;
    }
    /**
     * Set manual_transport_info value
     * @param string $manual_transport_info
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_transport_info($manual_transport_info = null)
    {
        // validation for constraint: string
        if (!is_null($manual_transport_info) && !is_string($manual_transport_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_transport_info)), __LINE__);
        }
        $this->manual_transport_info = $manual_transport_info;
        return $this;
    }
    /**
     * Get manual_area value
     * @return int|null
     */
    public function getManual_area()
    {
        return $this->manual_area;
    }
    /**
     * Set manual_area value
     * @param int $manual_area
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_area($manual_area = null)
    {
        // validation for constraint: int
        if (!is_null($manual_area) && !is_numeric($manual_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manual_area)), __LINE__);
        }
        $this->manual_area = $manual_area;
        return $this;
    }
    /**
     * Get manual_phone value
     * @return string|null
     */
    public function getManual_phone()
    {
        return $this->manual_phone;
    }
    /**
     * Set manual_phone value
     * @param string $manual_phone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setManual_phone($manual_phone = null)
    {
        // validation for constraint: string
        if (!is_null($manual_phone) && !is_string($manual_phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_phone)), __LINE__);
        }
        $this->manual_phone = $manual_phone;
        return $this;
    }
    /**
     * Get budget_invoice_price value
     * @return float|null
     */
    public function getBudget_invoice_price()
    {
        return $this->budget_invoice_price;
    }
    /**
     * Set budget_invoice_price value
     * @param float $budget_invoice_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBudget_invoice_price($budget_invoice_price = null)
    {
        $this->budget_invoice_price = $budget_invoice_price;
        return $this;
    }
    /**
     * Get budget_payment_price value
     * @return float|null
     */
    public function getBudget_payment_price()
    {
        return $this->budget_payment_price;
    }
    /**
     * Set budget_payment_price value
     * @param float $budget_payment_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setBudget_payment_price($budget_payment_price = null)
    {
        $this->budget_payment_price = $budget_payment_price;
        return $this;
    }
    /**
     * Get template_name value
     * @return string|null
     */
    public function getTemplate_name()
    {
        return $this->template_name;
    }
    /**
     * Set template_name value
     * @param string $template_name
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setTemplate_name($template_name = null)
    {
        // validation for constraint: string
        if (!is_null($template_name) && !is_string($template_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($template_name)), __LINE__);
        }
        $this->template_name = $template_name;
        return $this;
    }
    /**
     * Get global_location value
     * @return int|null
     */
    public function getGlobal_location()
    {
        return $this->global_location;
    }
    /**
     * Set global_location value
     * @param int $global_location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setGlobal_location($global_location = null)
    {
        // validation for constraint: int
        if (!is_null($global_location) && !is_numeric($global_location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($global_location)), __LINE__);
        }
        $this->global_location = $global_location;
        return $this;
    }
    /**
     * Get status_code value
     * @return int|null
     */
    public function getStatus_code()
    {
        return $this->status_code;
    }
    /**
     * Set status_code value
     * @param int $status_code
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setStatus_code($status_code = null)
    {
        // validation for constraint: int
        if (!is_null($status_code) && !is_numeric($status_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status_code)), __LINE__);
        }
        $this->status_code = $status_code;
        return $this;
    }
    /**
     * Get expected_month_coverage value
     * @return int|null
     */
    public function getExpected_month_coverage()
    {
        return $this->expected_month_coverage;
    }
    /**
     * Set expected_month_coverage value
     * @param int $expected_month_coverage
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setExpected_month_coverage($expected_month_coverage = null)
    {
        // validation for constraint: int
        if (!is_null($expected_month_coverage) && !is_numeric($expected_month_coverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expected_month_coverage)), __LINE__);
        }
        $this->expected_month_coverage = $expected_month_coverage;
        return $this;
    }
    /**
     * Get expected_coverage value
     * @return int|null
     */
    public function getExpected_coverage()
    {
        return $this->expected_coverage;
    }
    /**
     * Set expected_coverage value
     * @param int $expected_coverage
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setExpected_coverage($expected_coverage = null)
    {
        // validation for constraint: int
        if (!is_null($expected_coverage) && !is_numeric($expected_coverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expected_coverage)), __LINE__);
        }
        $this->expected_coverage = $expected_coverage;
        return $this;
    }
    /**
     * Get cancellation_reason value
     * @return int|null
     */
    public function getCancellation_reason()
    {
        return $this->cancellation_reason;
    }
    /**
     * Set cancellation_reason value
     * @param int $cancellation_reason
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCancellation_reason($cancellation_reason = null)
    {
        // validation for constraint: int
        if (!is_null($cancellation_reason) && !is_numeric($cancellation_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cancellation_reason)), __LINE__);
        }
        $this->cancellation_reason = $cancellation_reason;
        return $this;
    }
    /**
     * Get sdid value
     * @return int|null
     */
    public function getSdid()
    {
        return $this->sdid;
    }
    /**
     * Set sdid value
     * @param int $sdid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setSdid($sdid = null)
    {
        // validation for constraint: int
        if (!is_null($sdid) && !is_numeric($sdid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sdid)), __LINE__);
        }
        $this->sdid = $sdid;
        return $this;
    }
    /**
     * Get recruit_start value
     * @return string|null
     */
    public function getRecruit_start()
    {
        return $this->recruit_start;
    }
    /**
     * Set recruit_start value
     * @param string $recruit_start
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruit_start($recruit_start = null)
    {
        // validation for constraint: string
        if (!is_null($recruit_start) && !is_string($recruit_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recruit_start)), __LINE__);
        }
        $this->recruit_start = $recruit_start;
        return $this;
    }
    /**
     * Get recruit_stop value
     * @return string|null
     */
    public function getRecruit_stop()
    {
        return $this->recruit_stop;
    }
    /**
     * Set recruit_stop value
     * @param string $recruit_stop
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruit_stop($recruit_stop = null)
    {
        // validation for constraint: string
        if (!is_null($recruit_stop) && !is_string($recruit_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recruit_stop)), __LINE__);
        }
        $this->recruit_stop = $recruit_stop;
        return $this;
    }
    /**
     * Get recruit_consultantholder value
     * @return int|null
     */
    public function getRecruit_consultantholder()
    {
        return $this->recruit_consultantholder;
    }
    /**
     * Set recruit_consultantholder value
     * @param int $recruit_consultantholder
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setRecruit_consultantholder($recruit_consultantholder = null)
    {
        // validation for constraint: int
        if (!is_null($recruit_consultantholder) && !is_numeric($recruit_consultantholder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recruit_consultantholder)), __LINE__);
        }
        $this->recruit_consultantholder = $recruit_consultantholder;
        return $this;
    }
    /**
     * Get matchgroup value
     * @return int|null
     */
    public function getMatchgroup()
    {
        return $this->matchgroup;
    }
    /**
     * Set matchgroup value
     * @param int $matchgroup
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setMatchgroup($matchgroup = null)
    {
        // validation for constraint: int
        if (!is_null($matchgroup) && !is_numeric($matchgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchgroup)), __LINE__);
        }
        $this->matchgroup = $matchgroup;
        return $this;
    }
    /**
     * Get coaching_statuscode value
     * @return int|null
     */
    public function getCoaching_statuscode()
    {
        return $this->coaching_statuscode;
    }
    /**
     * Set coaching_statuscode value
     * @param int $coaching_statuscode
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCoaching_statuscode($coaching_statuscode = null)
    {
        // validation for constraint: int
        if (!is_null($coaching_statuscode) && !is_numeric($coaching_statuscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($coaching_statuscode)), __LINE__);
        }
        $this->coaching_statuscode = $coaching_statuscode;
        return $this;
    }
    /**
     * Get order_identity value
     * @return int|null
     */
    public function getOrder_identity()
    {
        return $this->order_identity;
    }
    /**
     * Set order_identity value
     * @param int $order_identity
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setOrder_identity($order_identity = null)
    {
        // validation for constraint: int
        if (!is_null($order_identity) && !is_numeric($order_identity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_identity)), __LINE__);
        }
        $this->order_identity = $order_identity;
        return $this;
    }
    /**
     * Get period_type value
     * @return int|null
     */
    public function getPeriod_type()
    {
        return $this->period_type;
    }
    /**
     * Set period_type value
     * @param int $period_type
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setPeriod_type($period_type = null)
    {
        // validation for constraint: int
        if (!is_null($period_type) && !is_numeric($period_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($period_type)), __LINE__);
        }
        $this->period_type = $period_type;
        return $this;
    }
    /**
     * Get period_end_day value
     * @return int|null
     */
    public function getPeriod_end_day()
    {
        return $this->period_end_day;
    }
    /**
     * Set period_end_day value
     * @param int $period_end_day
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setPeriod_end_day($period_end_day = null)
    {
        // validation for constraint: int
        if (!is_null($period_end_day) && !is_numeric($period_end_day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($period_end_day)), __LINE__);
        }
        $this->period_end_day = $period_end_day;
        return $this;
    }
    /**
     * Get intern_note value
     * @return string|null
     */
    public function getIntern_note()
    {
        return $this->intern_note;
    }
    /**
     * Set intern_note value
     * @param string $intern_note
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setIntern_note($intern_note = null)
    {
        // validation for constraint: string
        if (!is_null($intern_note) && !is_string($intern_note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intern_note)), __LINE__);
        }
        $this->intern_note = $intern_note;
        return $this;
    }
    /**
     * Get customer_consultant value
     * @return int|null
     */
    public function getCustomer_consultant()
    {
        return $this->customer_consultant;
    }
    /**
     * Set customer_consultant value
     * @param int $customer_consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCustomer_consultant($customer_consultant = null)
    {
        // validation for constraint: int
        if (!is_null($customer_consultant) && !is_numeric($customer_consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_consultant)), __LINE__);
        }
        $this->customer_consultant = $customer_consultant;
        return $this;
    }
    /**
     * Get custom_timesheet_recipient value
     * @return int|null
     */
    public function getCustom_timesheet_recipient()
    {
        return $this->custom_timesheet_recipient;
    }
    /**
     * Set custom_timesheet_recipient value
     * @param int $custom_timesheet_recipient
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setCustom_timesheet_recipient($custom_timesheet_recipient = null)
    {
        // validation for constraint: int
        if (!is_null($custom_timesheet_recipient) && !is_numeric($custom_timesheet_recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($custom_timesheet_recipient)), __LINE__);
        }
        $this->custom_timesheet_recipient = $custom_timesheet_recipient;
        return $this;
    }
    /**
     * Get week_input value
     * @return string|null
     */
    public function getWeek_input()
    {
        return $this->week_input;
    }
    /**
     * Set week_input value
     * @param string $week_input
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setWeek_input($week_input = null)
    {
        // validation for constraint: string
        if (!is_null($week_input) && !is_string($week_input)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($week_input)), __LINE__);
        }
        $this->week_input = $week_input;
        return $this;
    }
    /**
     * Get dont_book_holidays value
     * @return bool|null
     */
    public function getDont_book_holidays()
    {
        return $this->dont_book_holidays;
    }
    /**
     * Set dont_book_holidays value
     * @param bool $dont_book_holidays
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public function setDont_book_holidays($dont_book_holidays = null)
    {
        // validation for constraint: boolean
        if (!is_null($dont_book_holidays) && !is_bool($dont_book_holidays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dont_book_holidays)), __LINE__);
        }
        $this->dont_book_holidays = $dont_book_holidays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
