<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpFieldOfWork StructType
 * @subpackage Structs
 */
class AxpFieldOfWork extends AbstractStructBase
{
    /**
     * The fid
     * @var int
     */
    public $fid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * Constructor method for AxpFieldOfWork
     * @uses AxpFieldOfWork::setFid()
     * @uses AxpFieldOfWork::setLabel()
     * @param int $fid
     * @param string $label
     */
    public function __construct($fid = null, $label = null)
    {
        $this
            ->setFid($fid)
            ->setLabel($label);
    }
    /**
     * Get fid value
     * @return int|null
     */
    public function getFid()
    {
        return $this->fid;
    }
    /**
     * Set fid value
     * @param int $fid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpFieldOfWork
     */
    public function setFid($fid = null)
    {
        // validation for constraint: int
        if (!is_null($fid) && !is_numeric($fid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fid)), __LINE__);
        }
        $this->fid = $fid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpFieldOfWork
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpFieldOfWork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
