<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpBusinessArea StructType
 * @subpackage Structs
 */
class AxpBusinessArea extends AbstractStructBase
{
    /**
     * The baid
     * @var int
     */
    public $baid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The cvfid
     * @var int
     */
    public $cvfid;
    /**
     * The cid
     * @var int
     */
    public $cid;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The shortname
     * @var string
     */
    public $shortname;
    /**
     * The cost_factor
     * @var float
     */
    public $cost_factor;
    /**
     * The sid
     * @var int
     */
    public $sid;
    /**
     * The flags
     * @var int
     */
    public $flags;
    /**
     * The intern_ba
     * @var bool
     */
    public $intern_ba;
    /**
     * Constructor method for AxpBusinessArea
     * @uses AxpBusinessArea::setBaid()
     * @uses AxpBusinessArea::setLabel()
     * @uses AxpBusinessArea::setCvfid()
     * @uses AxpBusinessArea::setCid()
     * @uses AxpBusinessArea::setDescription()
     * @uses AxpBusinessArea::setShortname()
     * @uses AxpBusinessArea::setCost_factor()
     * @uses AxpBusinessArea::setSid()
     * @uses AxpBusinessArea::setFlags()
     * @uses AxpBusinessArea::setIntern_ba()
     * @param int $baid
     * @param string $label
     * @param int $cvfid
     * @param int $cid
     * @param string $description
     * @param string $shortname
     * @param float $cost_factor
     * @param int $sid
     * @param int $flags
     * @param bool $intern_ba
     */
    public function __construct($baid = null, $label = null, $cvfid = null, $cid = null, $description = null, $shortname = null, $cost_factor = null, $sid = null, $flags = null, $intern_ba = null)
    {
        $this
            ->setBaid($baid)
            ->setLabel($label)
            ->setCvfid($cvfid)
            ->setCid($cid)
            ->setDescription($description)
            ->setShortname($shortname)
            ->setCost_factor($cost_factor)
            ->setSid($sid)
            ->setFlags($flags)
            ->setIntern_ba($intern_ba);
    }
    /**
     * Get baid value
     * @return int|null
     */
    public function getBaid()
    {
        return $this->baid;
    }
    /**
     * Set baid value
     * @param int $baid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setBaid($baid = null)
    {
        // validation for constraint: int
        if (!is_null($baid) && !is_numeric($baid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($baid)), __LINE__);
        }
        $this->baid = $baid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get cvfid value
     * @return int|null
     */
    public function getCvfid()
    {
        return $this->cvfid;
    }
    /**
     * Set cvfid value
     * @param int $cvfid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setCvfid($cvfid = null)
    {
        // validation for constraint: int
        if (!is_null($cvfid) && !is_numeric($cvfid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cvfid)), __LINE__);
        }
        $this->cvfid = $cvfid;
        return $this;
    }
    /**
     * Get cid value
     * @return int|null
     */
    public function getCid()
    {
        return $this->cid;
    }
    /**
     * Set cid value
     * @param int $cid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setCid($cid = null)
    {
        // validation for constraint: int
        if (!is_null($cid) && !is_numeric($cid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cid)), __LINE__);
        }
        $this->cid = $cid;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get shortname value
     * @return string|null
     */
    public function getShortname()
    {
        return $this->shortname;
    }
    /**
     * Set shortname value
     * @param string $shortname
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setShortname($shortname = null)
    {
        // validation for constraint: string
        if (!is_null($shortname) && !is_string($shortname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortname)), __LINE__);
        }
        $this->shortname = $shortname;
        return $this;
    }
    /**
     * Get cost_factor value
     * @return float|null
     */
    public function getCost_factor()
    {
        return $this->cost_factor;
    }
    /**
     * Set cost_factor value
     * @param float $cost_factor
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setCost_factor($cost_factor = null)
    {
        $this->cost_factor = $cost_factor;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !is_numeric($flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get intern_ba value
     * @return bool|null
     */
    public function getIntern_ba()
    {
        return $this->intern_ba;
    }
    /**
     * Set intern_ba value
     * @param bool $intern_ba
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public function setIntern_ba($intern_ba = null)
    {
        // validation for constraint: boolean
        if (!is_null($intern_ba) && !is_bool($intern_ba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($intern_ba)), __LINE__);
        }
        $this->intern_ba = $intern_ba;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
