<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpBooking StructType
 * @subpackage Structs
 */
class AxpBooking extends AbstractStructBase
{
    /**
     * The orid
     * @var int
     */
    public $orid;
    /**
     * The olid
     * @var int
     */
    public $olid;
    /**
     * The shifts
     * Meta informations extracted from the WSDL
     * - arrayType: tns:AxpBookingShift[]
     * - ref: SOAP-ENC:arrayType
     * @var \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift[]
     */
    public $shifts;
    /**
     * Constructor method for AxpBooking
     * @uses AxpBooking::setOrid()
     * @uses AxpBooking::setOlid()
     * @uses AxpBooking::setShifts()
     * @param int $orid
     * @param int $olid
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift[] $shifts
     */
    public function __construct($orid = null, $olid = null, array $shifts = array())
    {
        $this
            ->setOrid($orid)
            ->setOlid($olid)
            ->setShifts($shifts);
    }
    /**
     * Get orid value
     * @return int|null
     */
    public function getOrid()
    {
        return $this->orid;
    }
    /**
     * Set orid value
     * @param int $orid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking
     */
    public function setOrid($orid = null)
    {
        // validation for constraint: int
        if (!is_null($orid) && !is_numeric($orid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orid)), __LINE__);
        }
        $this->orid = $orid;
        return $this;
    }
    /**
     * Get olid value
     * @return int|null
     */
    public function getOlid()
    {
        return $this->olid;
    }
    /**
     * Set olid value
     * @param int $olid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking
     */
    public function setOlid($olid = null)
    {
        // validation for constraint: int
        if (!is_null($olid) && !is_numeric($olid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($olid)), __LINE__);
        }
        $this->olid = $olid;
        return $this;
    }
    /**
     * Get shifts value
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift[]|null
     */
    public function getShifts()
    {
        return $this->shifts;
    }
    /**
     * Set shifts value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift[] $shifts
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking
     */
    public function setShifts(array $shifts = array())
    {
        foreach ($shifts as $axpBookingShiftsItem) {
            // validation for constraint: itemType
            if (!$axpBookingShiftsItem instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift) {
                throw new \InvalidArgumentException(sprintf('The shifts property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift, "%s" given', is_object($axpBookingShiftsItem) ? get_class($axpBookingShiftsItem) : gettype($axpBookingShiftsItem)), __LINE__);
            }
        }
        $this->shifts = $shifts;
        return $this;
    }
    /**
     * Add item to shifts value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking
     */
    public function addToShifts(\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift) {
            throw new \InvalidArgumentException(sprintf('The shifts property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBookingShift, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shifts[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
