<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named uploadOneCandidate
     * Meta informations extracted from the WSDL
     * - documentation: Uploads a candidate to AXP. Candidate is matched on external ID. If no match is found, a candidate will be created with all the information for this service. If a match is found, only certain fields will be updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTemp $axpTemp
     * @param string $documentList
     * @param string $axpTempBizareasList
     * @param string $axpTempHistList
     * @param string $axpTempSkillsList
     * @param string $axpTempAnnotationList
     * @param string $axpTempEduList
     * @param string $geoAreas
     * @return array|bool
     */
    public function uploadOneCandidate($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTemp $axpTemp, $documentList, $axpTempBizareasList, $axpTempHistList, $axpTempSkillsList, $axpTempAnnotationList, $axpTempEduList, $geoAreas)
    {
        try {
            $this->setResult(self::getSoapClient()->uploadOneCandidate($handle, $axpTemp, $documentList, $axpTempBizareasList, $axpTempHistList, $axpTempSkillsList, $axpTempAnnotationList, $axpTempEduList, $geoAreas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
