<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateCustomer
     * Meta informations extracted from the WSDL
     * - documentation: Updates a customer in the AXP system
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_id
     * @param string $cust_no
     * @param string $company
     * @param string $addr1
     * @param string $addr2
     * @param string $zip
     * @param string $city
     * @param string $company_no
     * @param string $employees
     * @param string $phone
     * @param string $phone2
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param string $active
     * @param string $customergroup
     * @param string $discount
     * @param string $consultant
     * @param string $secondary_consultant
     * @param \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString $departments
     * @param string $notes
     * @param string $partners_agreement
     * @param string $partners_agreement_end
     * @param string $customergroup_id
     * @return boolean|bool
     */
    public function updateCustomer($handle, $cust_id, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString $departments, $notes, $partners_agreement, $partners_agreement_end, $customergroup_id)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCustomer($handle, $cust_id, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, $departments, $notes, $partners_agreement, $partners_agreement_end, $customergroup_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateContact
     * Meta informations extracted from the WSDL
     * - documentation: Updates a customer contact in the AXP system
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $uid
     * @param string $cust_id
     * @param string $cust_no
     * @param string $fname
     * @param string $lname
     * @param string $title
     * @param string $email
     * @param string $phone
     * @param string $mobile
     * @param string $active
     * @param string $is_primary
     * @return boolean|bool
     */
    public function updateContact($handle, $uid, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary)
    {
        try {
            $this->setResult(self::getSoapClient()->updateContact($handle, $uid, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAxpCustomer
     * Meta informations extracted from the WSDL
     * - documentation: update customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw $customer
     * @return string|bool
     */
    public function updateAxpCustomer($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw $customer)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAxpCustomer($handle, $customer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAxpCustomerContact
     * Meta informations extracted from the WSDL
     * - documentation: update customer contact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw $contact
     * @return int|bool
     */
    public function updateAxpCustomerContact($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw $contact)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAxpCustomerContact($handle, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAxpTempOrder
     * Meta informations extracted from the WSDL
     * - documentation: updates a newly created temp order, orid is used to identify the order to update, status and type will be ignored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder $order
     * @param string $orid
     * @return int|bool
     */
    public function updateAxpTempOrder($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder $order, $orid)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAxpTempOrder($handle, $order, $orid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAxpTempClassification
     * Meta informations extracted from the WSDL
     * - documentation: Updates axpTemp classification with new classification. Examples of valid clasifications. Active Temp: 64 , Passive Temp: 32 , Subject: 8 , None: 1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $tid
     * @param string $classification
     * @return boolean|bool
     */
    public function updateAxpTempClassification($handle, $tid, $classification)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAxpTempClassification($handle, $tid, $classification));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
