<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The itemName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $itemName;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setItemName()
     * @param string[] $itemName
     */
    public function __construct(array $itemName = array())
    {
        $this
            ->setItemName($itemName);
    }
    /**
     * Get itemName value
     * @return string[]|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @throws \InvalidArgumentException
     * @param string[] $itemName
     * @return \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString
     */
    public function setItemName(array $itemName = array())
    {
        foreach ($itemName as $arrayOfStringItemNameItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringItemNameItem)) {
                throw new \InvalidArgumentException(sprintf('The itemName property can only contain items of string, "%s" given', is_object($arrayOfStringItemNameItem) ? get_class($arrayOfStringItemNameItem) : gettype($arrayOfStringItemNameItem)), __LINE__);
            }
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Add item to itemName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString
     */
    public function addToItemName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The itemName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->itemName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string itemName
     */
    public function getAttributeName()
    {
        return 'itemName';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
