<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The messageText
     * @var string
     */
    public $messageText;
    /**
     * The messageCode
     * @var string
     */
    public $messageCode;
    /**
     * The messageTime
     * @var string
     */
    public $messageTime;
    /**
     * Constructor method for message
     * @uses Message::setMessageText()
     * @uses Message::setMessageCode()
     * @uses Message::setMessageTime()
     * @param string $messageText
     * @param string $messageCode
     * @param string $messageTime
     */
    public function __construct($messageText = null, $messageCode = null, $messageTime = null)
    {
        $this
            ->setMessageText($messageText)
            ->setMessageCode($messageCode)
            ->setMessageTime($messageTime);
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Message
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get messageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->messageCode;
    }
    /**
     * Set messageCode value
     * @param string $messageCode
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Message
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageCode)), __LINE__);
        }
        $this->messageCode = $messageCode;
        return $this;
    }
    /**
     * Get messageTime value
     * @return string|null
     */
    public function getMessageTime()
    {
        return $this->messageTime;
    }
    /**
     * Set messageTime value
     * @param string $messageTime
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Message
     */
    public function setMessageTime($messageTime = null)
    {
        // validation for constraint: string
        if (!is_null($messageTime) && !is_string($messageTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageTime)), __LINE__);
        }
        $this->messageTime = $messageTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
