<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpTempAnnotation StructType
 * @subpackage Structs
 */
class AxpTempAnnotation extends AbstractStructBase
{
    /**
     * The tid
     * @var int
     */
    public $tid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The descr
     * @var string
     */
    public $descr;
    /**
     * Constructor method for AxpTempAnnotation
     * @uses AxpTempAnnotation::setTid()
     * @uses AxpTempAnnotation::setLabel()
     * @uses AxpTempAnnotation::setDescr()
     * @param int $tid
     * @param string $label
     * @param string $descr
     */
    public function __construct($tid = null, $label = null, $descr = null)
    {
        $this
            ->setTid($tid)
            ->setLabel($label)
            ->setDescr($descr);
    }
    /**
     * Get tid value
     * @return int|null
     */
    public function getTid()
    {
        return $this->tid;
    }
    /**
     * Set tid value
     * @param int $tid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempAnnotation
     */
    public function setTid($tid = null)
    {
        // validation for constraint: int
        if (!is_null($tid) && !is_numeric($tid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tid)), __LINE__);
        }
        $this->tid = $tid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempAnnotation
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get descr value
     * @return string|null
     */
    public function getDescr()
    {
        return $this->descr;
    }
    /**
     * Set descr value
     * @param string $descr
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempAnnotation
     */
    public function setDescr($descr = null)
    {
        // validation for constraint: string
        if (!is_null($descr) && !is_string($descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descr)), __LINE__);
        }
        $this->descr = $descr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempAnnotation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
