<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpShiftData StructType
 * @subpackage Structs
 */
class AxpShiftData extends AbstractStructBase
{
    /**
     * The tid
     * @var int
     */
    public $tid;
    /**
     * The orid
     * @var int
     */
    public $orid;
    /**
     * The day
     * @var string
     */
    public $day;
    /**
     * The from_time
     * @var string
     */
    public $from_time;
    /**
     * The to_time
     * @var string
     */
    public $to_time;
    /**
     * The break_minutes
     * @var int
     */
    public $break_minutes;
    /**
     * The break_hours
     * @var float
     */
    public $break_hours;
    /**
     * The used
     * @var bool
     */
    public $used;
    /**
     * The overwrite_registration
     * @var bool
     */
    public $overwrite_registration;
    /**
     * Constructor method for AxpShiftData
     * @uses AxpShiftData::setTid()
     * @uses AxpShiftData::setOrid()
     * @uses AxpShiftData::setDay()
     * @uses AxpShiftData::setFrom_time()
     * @uses AxpShiftData::setTo_time()
     * @uses AxpShiftData::setBreak_minutes()
     * @uses AxpShiftData::setBreak_hours()
     * @uses AxpShiftData::setUsed()
     * @uses AxpShiftData::setOverwrite_registration()
     * @param int $tid
     * @param int $orid
     * @param string $day
     * @param string $from_time
     * @param string $to_time
     * @param int $break_minutes
     * @param float $break_hours
     * @param bool $used
     * @param bool $overwrite_registration
     */
    public function __construct($tid = null, $orid = null, $day = null, $from_time = null, $to_time = null, $break_minutes = null, $break_hours = null, $used = null, $overwrite_registration = null)
    {
        $this
            ->setTid($tid)
            ->setOrid($orid)
            ->setDay($day)
            ->setFrom_time($from_time)
            ->setTo_time($to_time)
            ->setBreak_minutes($break_minutes)
            ->setBreak_hours($break_hours)
            ->setUsed($used)
            ->setOverwrite_registration($overwrite_registration);
    }
    /**
     * Get tid value
     * @return int|null
     */
    public function getTid()
    {
        return $this->tid;
    }
    /**
     * Set tid value
     * @param int $tid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setTid($tid = null)
    {
        // validation for constraint: int
        if (!is_null($tid) && !is_numeric($tid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tid)), __LINE__);
        }
        $this->tid = $tid;
        return $this;
    }
    /**
     * Get orid value
     * @return int|null
     */
    public function getOrid()
    {
        return $this->orid;
    }
    /**
     * Set orid value
     * @param int $orid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setOrid($orid = null)
    {
        // validation for constraint: int
        if (!is_null($orid) && !is_numeric($orid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orid)), __LINE__);
        }
        $this->orid = $orid;
        return $this;
    }
    /**
     * Get day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param string $day
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get from_time value
     * @return string|null
     */
    public function getFrom_time()
    {
        return $this->from_time;
    }
    /**
     * Set from_time value
     * @param string $from_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setFrom_time($from_time = null)
    {
        // validation for constraint: string
        if (!is_null($from_time) && !is_string($from_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_time)), __LINE__);
        }
        $this->from_time = $from_time;
        return $this;
    }
    /**
     * Get to_time value
     * @return string|null
     */
    public function getTo_time()
    {
        return $this->to_time;
    }
    /**
     * Set to_time value
     * @param string $to_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setTo_time($to_time = null)
    {
        // validation for constraint: string
        if (!is_null($to_time) && !is_string($to_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_time)), __LINE__);
        }
        $this->to_time = $to_time;
        return $this;
    }
    /**
     * Get break_minutes value
     * @return int|null
     */
    public function getBreak_minutes()
    {
        return $this->break_minutes;
    }
    /**
     * Set break_minutes value
     * @param int $break_minutes
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setBreak_minutes($break_minutes = null)
    {
        // validation for constraint: int
        if (!is_null($break_minutes) && !is_numeric($break_minutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($break_minutes)), __LINE__);
        }
        $this->break_minutes = $break_minutes;
        return $this;
    }
    /**
     * Get break_hours value
     * @return float|null
     */
    public function getBreak_hours()
    {
        return $this->break_hours;
    }
    /**
     * Set break_hours value
     * @param float $break_hours
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setBreak_hours($break_hours = null)
    {
        $this->break_hours = $break_hours;
        return $this;
    }
    /**
     * Get used value
     * @return bool|null
     */
    public function getUsed()
    {
        return $this->used;
    }
    /**
     * Set used value
     * @param bool $used
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setUsed($used = null)
    {
        // validation for constraint: boolean
        if (!is_null($used) && !is_bool($used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($used)), __LINE__);
        }
        $this->used = $used;
        return $this;
    }
    /**
     * Get overwrite_registration value
     * @return bool|null
     */
    public function getOverwrite_registration()
    {
        return $this->overwrite_registration;
    }
    /**
     * Set overwrite_registration value
     * @param bool $overwrite_registration
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public function setOverwrite_registration($overwrite_registration = null)
    {
        // validation for constraint: boolean
        if (!is_null($overwrite_registration) && !is_bool($overwrite_registration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overwrite_registration)), __LINE__);
        }
        $this->overwrite_registration = $overwrite_registration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
