<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpProject StructType
 * @subpackage Structs
 */
class AxpProject extends AbstractStructBase
{
    /**
     * The projectId
     * @var string
     */
    public $projectId;
    /**
     * The projectStatus
     * @var string
     */
    public $projectStatus;
    /**
     * The projectCompany
     * @var string
     */
    public $projectCompany;
    /**
     * The projectLocation
     * @var string
     */
    public $projectLocation;
    /**
     * The projectAddress1
     * @var string
     */
    public $projectAddress1;
    /**
     * The projectAddress2
     * @var string
     */
    public $projectAddress2;
    /**
     * The projectZip
     * @var string
     */
    public $projectZip;
    /**
     * The projectCity
     * @var string
     */
    public $projectCity;
    /**
     * The projectPhone
     * @var string
     */
    public $projectPhone;
    /**
     * The projectWorkContactName
     * @var string
     */
    public $projectWorkContactName;
    /**
     * The projectWorkContactPhone
     * @var string
     */
    public $projectWorkContactPhone;
    /**
     * The projectWorkContactMobile
     * @var string
     */
    public $projectWorkContactMobile;
    /**
     * The projectReference
     * @var string
     */
    public $projectReference;
    /**
     * The projectDepartment
     * @var string
     */
    public $projectDepartment;
    /**
     * The projectConsultantName
     * @var string
     */
    public $projectConsultantName;
    /**
     * The projectBizarea
     * @var string
     */
    public $projectBizarea;
    /**
     * The projectItemList
     * Meta informations extracted from the WSDL
     * - arrayType: tns:AxpProjectItem[]
     * - ref: SOAP-ENC:arrayType
     * @var \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem[]
     */
    public $projectItemList;
    /**
     * Constructor method for AxpProject
     * @uses AxpProject::setProjectId()
     * @uses AxpProject::setProjectStatus()
     * @uses AxpProject::setProjectCompany()
     * @uses AxpProject::setProjectLocation()
     * @uses AxpProject::setProjectAddress1()
     * @uses AxpProject::setProjectAddress2()
     * @uses AxpProject::setProjectZip()
     * @uses AxpProject::setProjectCity()
     * @uses AxpProject::setProjectPhone()
     * @uses AxpProject::setProjectWorkContactName()
     * @uses AxpProject::setProjectWorkContactPhone()
     * @uses AxpProject::setProjectWorkContactMobile()
     * @uses AxpProject::setProjectReference()
     * @uses AxpProject::setProjectDepartment()
     * @uses AxpProject::setProjectConsultantName()
     * @uses AxpProject::setProjectBizarea()
     * @uses AxpProject::setProjectItemList()
     * @param string $projectId
     * @param string $projectStatus
     * @param string $projectCompany
     * @param string $projectLocation
     * @param string $projectAddress1
     * @param string $projectAddress2
     * @param string $projectZip
     * @param string $projectCity
     * @param string $projectPhone
     * @param string $projectWorkContactName
     * @param string $projectWorkContactPhone
     * @param string $projectWorkContactMobile
     * @param string $projectReference
     * @param string $projectDepartment
     * @param string $projectConsultantName
     * @param string $projectBizarea
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem[] $projectItemList
     */
    public function __construct($projectId = null, $projectStatus = null, $projectCompany = null, $projectLocation = null, $projectAddress1 = null, $projectAddress2 = null, $projectZip = null, $projectCity = null, $projectPhone = null, $projectWorkContactName = null, $projectWorkContactPhone = null, $projectWorkContactMobile = null, $projectReference = null, $projectDepartment = null, $projectConsultantName = null, $projectBizarea = null, array $projectItemList = array())
    {
        $this
            ->setProjectId($projectId)
            ->setProjectStatus($projectStatus)
            ->setProjectCompany($projectCompany)
            ->setProjectLocation($projectLocation)
            ->setProjectAddress1($projectAddress1)
            ->setProjectAddress2($projectAddress2)
            ->setProjectZip($projectZip)
            ->setProjectCity($projectCity)
            ->setProjectPhone($projectPhone)
            ->setProjectWorkContactName($projectWorkContactName)
            ->setProjectWorkContactPhone($projectWorkContactPhone)
            ->setProjectWorkContactMobile($projectWorkContactMobile)
            ->setProjectReference($projectReference)
            ->setProjectDepartment($projectDepartment)
            ->setProjectConsultantName($projectConsultantName)
            ->setProjectBizarea($projectBizarea)
            ->setProjectItemList($projectItemList);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get projectStatus value
     * @return string|null
     */
    public function getProjectStatus()
    {
        return $this->projectStatus;
    }
    /**
     * Set projectStatus value
     * @param string $projectStatus
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectStatus($projectStatus = null)
    {
        // validation for constraint: string
        if (!is_null($projectStatus) && !is_string($projectStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectStatus)), __LINE__);
        }
        $this->projectStatus = $projectStatus;
        return $this;
    }
    /**
     * Get projectCompany value
     * @return string|null
     */
    public function getProjectCompany()
    {
        return $this->projectCompany;
    }
    /**
     * Set projectCompany value
     * @param string $projectCompany
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectCompany($projectCompany = null)
    {
        // validation for constraint: string
        if (!is_null($projectCompany) && !is_string($projectCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectCompany)), __LINE__);
        }
        $this->projectCompany = $projectCompany;
        return $this;
    }
    /**
     * Get projectLocation value
     * @return string|null
     */
    public function getProjectLocation()
    {
        return $this->projectLocation;
    }
    /**
     * Set projectLocation value
     * @param string $projectLocation
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectLocation($projectLocation = null)
    {
        // validation for constraint: string
        if (!is_null($projectLocation) && !is_string($projectLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectLocation)), __LINE__);
        }
        $this->projectLocation = $projectLocation;
        return $this;
    }
    /**
     * Get projectAddress1 value
     * @return string|null
     */
    public function getProjectAddress1()
    {
        return $this->projectAddress1;
    }
    /**
     * Set projectAddress1 value
     * @param string $projectAddress1
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectAddress1($projectAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($projectAddress1) && !is_string($projectAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectAddress1)), __LINE__);
        }
        $this->projectAddress1 = $projectAddress1;
        return $this;
    }
    /**
     * Get projectAddress2 value
     * @return string|null
     */
    public function getProjectAddress2()
    {
        return $this->projectAddress2;
    }
    /**
     * Set projectAddress2 value
     * @param string $projectAddress2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectAddress2($projectAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($projectAddress2) && !is_string($projectAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectAddress2)), __LINE__);
        }
        $this->projectAddress2 = $projectAddress2;
        return $this;
    }
    /**
     * Get projectZip value
     * @return string|null
     */
    public function getProjectZip()
    {
        return $this->projectZip;
    }
    /**
     * Set projectZip value
     * @param string $projectZip
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectZip($projectZip = null)
    {
        // validation for constraint: string
        if (!is_null($projectZip) && !is_string($projectZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectZip)), __LINE__);
        }
        $this->projectZip = $projectZip;
        return $this;
    }
    /**
     * Get projectCity value
     * @return string|null
     */
    public function getProjectCity()
    {
        return $this->projectCity;
    }
    /**
     * Set projectCity value
     * @param string $projectCity
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectCity($projectCity = null)
    {
        // validation for constraint: string
        if (!is_null($projectCity) && !is_string($projectCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectCity)), __LINE__);
        }
        $this->projectCity = $projectCity;
        return $this;
    }
    /**
     * Get projectPhone value
     * @return string|null
     */
    public function getProjectPhone()
    {
        return $this->projectPhone;
    }
    /**
     * Set projectPhone value
     * @param string $projectPhone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectPhone($projectPhone = null)
    {
        // validation for constraint: string
        if (!is_null($projectPhone) && !is_string($projectPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectPhone)), __LINE__);
        }
        $this->projectPhone = $projectPhone;
        return $this;
    }
    /**
     * Get projectWorkContactName value
     * @return string|null
     */
    public function getProjectWorkContactName()
    {
        return $this->projectWorkContactName;
    }
    /**
     * Set projectWorkContactName value
     * @param string $projectWorkContactName
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectWorkContactName($projectWorkContactName = null)
    {
        // validation for constraint: string
        if (!is_null($projectWorkContactName) && !is_string($projectWorkContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectWorkContactName)), __LINE__);
        }
        $this->projectWorkContactName = $projectWorkContactName;
        return $this;
    }
    /**
     * Get projectWorkContactPhone value
     * @return string|null
     */
    public function getProjectWorkContactPhone()
    {
        return $this->projectWorkContactPhone;
    }
    /**
     * Set projectWorkContactPhone value
     * @param string $projectWorkContactPhone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectWorkContactPhone($projectWorkContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($projectWorkContactPhone) && !is_string($projectWorkContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectWorkContactPhone)), __LINE__);
        }
        $this->projectWorkContactPhone = $projectWorkContactPhone;
        return $this;
    }
    /**
     * Get projectWorkContactMobile value
     * @return string|null
     */
    public function getProjectWorkContactMobile()
    {
        return $this->projectWorkContactMobile;
    }
    /**
     * Set projectWorkContactMobile value
     * @param string $projectWorkContactMobile
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectWorkContactMobile($projectWorkContactMobile = null)
    {
        // validation for constraint: string
        if (!is_null($projectWorkContactMobile) && !is_string($projectWorkContactMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectWorkContactMobile)), __LINE__);
        }
        $this->projectWorkContactMobile = $projectWorkContactMobile;
        return $this;
    }
    /**
     * Get projectReference value
     * @return string|null
     */
    public function getProjectReference()
    {
        return $this->projectReference;
    }
    /**
     * Set projectReference value
     * @param string $projectReference
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectReference($projectReference = null)
    {
        // validation for constraint: string
        if (!is_null($projectReference) && !is_string($projectReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectReference)), __LINE__);
        }
        $this->projectReference = $projectReference;
        return $this;
    }
    /**
     * Get projectDepartment value
     * @return string|null
     */
    public function getProjectDepartment()
    {
        return $this->projectDepartment;
    }
    /**
     * Set projectDepartment value
     * @param string $projectDepartment
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectDepartment($projectDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($projectDepartment) && !is_string($projectDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectDepartment)), __LINE__);
        }
        $this->projectDepartment = $projectDepartment;
        return $this;
    }
    /**
     * Get projectConsultantName value
     * @return string|null
     */
    public function getProjectConsultantName()
    {
        return $this->projectConsultantName;
    }
    /**
     * Set projectConsultantName value
     * @param string $projectConsultantName
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectConsultantName($projectConsultantName = null)
    {
        // validation for constraint: string
        if (!is_null($projectConsultantName) && !is_string($projectConsultantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectConsultantName)), __LINE__);
        }
        $this->projectConsultantName = $projectConsultantName;
        return $this;
    }
    /**
     * Get projectBizarea value
     * @return string|null
     */
    public function getProjectBizarea()
    {
        return $this->projectBizarea;
    }
    /**
     * Set projectBizarea value
     * @param string $projectBizarea
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectBizarea($projectBizarea = null)
    {
        // validation for constraint: string
        if (!is_null($projectBizarea) && !is_string($projectBizarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectBizarea)), __LINE__);
        }
        $this->projectBizarea = $projectBizarea;
        return $this;
    }
    /**
     * Get projectItemList value
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem[]|null
     */
    public function getProjectItemList()
    {
        return $this->projectItemList;
    }
    /**
     * Set projectItemList value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem[] $projectItemList
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function setProjectItemList(array $projectItemList = array())
    {
        foreach ($projectItemList as $axpProjectProjectItemListItem) {
            // validation for constraint: itemType
            if (!$axpProjectProjectItemListItem instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem) {
                throw new \InvalidArgumentException(sprintf('The projectItemList property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem, "%s" given', is_object($axpProjectProjectItemListItem) ? get_class($axpProjectProjectItemListItem) : gettype($axpProjectProjectItemListItem)), __LINE__);
            }
        }
        $this->projectItemList = $projectItemList;
        return $this;
    }
    /**
     * Add item to projectItemList value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public function addToProjectItemList(\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem) {
            throw new \InvalidArgumentException(sprintf('The projectItemList property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProjectItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->projectItemList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
