<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpErpSegment StructType
 * @subpackage Structs
 */
class AxpErpSegment extends AbstractStructBase
{
    /**
     * The esid
     * @var int
     */
    public $esid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * Constructor method for AxpErpSegment
     * @uses AxpErpSegment::setEsid()
     * @uses AxpErpSegment::setLabel()
     * @param int $esid
     * @param string $label
     */
    public function __construct($esid = null, $label = null)
    {
        $this
            ->setEsid($esid)
            ->setLabel($label);
    }
    /**
     * Get esid value
     * @return int|null
     */
    public function getEsid()
    {
        return $this->esid;
    }
    /**
     * Set esid value
     * @param int $esid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpErpSegment
     */
    public function setEsid($esid = null)
    {
        // validation for constraint: int
        if (!is_null($esid) && !is_numeric($esid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($esid)), __LINE__);
        }
        $this->esid = $esid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpErpSegment
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpErpSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
