<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpCustomerContactRaw StructType
 * @subpackage Structs
 */
class AxpCustomerContactRaw extends AbstractStructBase
{
    /**
     * The ccid
     * @var int
     */
    public $ccid;
    /**
     * The uid
     * @var int
     */
    public $uid;
    /**
     * The cust_id
     * @var int
     */
    public $cust_id;
    /**
     * The clid
     * @var int
     */
    public $clid;
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The fname
     * @var string
     */
    public $fname;
    /**
     * The lname
     * @var string
     */
    public $lname;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The phone
     * @var string
     */
    public $phone;
    /**
     * The mobile
     * @var string
     */
    public $mobile;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The work_loc
     * @var int
     */
    public $work_loc;
    /**
     * The systemmail
     * @var int
     */
    public $systemmail;
    /**
     * The note
     * @var string
     */
    public $note;
    /**
     * The canrate
     * @var int
     */
    public $canrate;
    /**
     * The active
     * @var int
     */
    public $active;
    /**
     * The is_primary
     * @var int
     */
    public $is_primary;
    /**
     * The last_auto_notification
     * @var string
     */
    public $last_auto_notification;
    /**
     * The receive_timesheet_receipt
     * @var int
     */
    public $receive_timesheet_receipt;
    /**
     * The report_level
     * @var int
     */
    public $report_level;
    /**
     * The newsletter
     * @var int
     */
    public $newsletter;
    /**
     * The timesheet_cc
     * @var int
     */
    public $timesheet_cc;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The see_price
     * @var bool
     */
    public $see_price;
    /**
     * The see_salary
     * @var bool
     */
    public $see_salary;
    /**
     * The see_discount
     * @var bool
     */
    public $see_discount;
    /**
     * The see_temp
     * @var bool
     */
    public $see_temp;
    /**
     * The see_fname_plus
     * @var bool
     */
    public $see_fname_plus;
    /**
     * The see_lname
     * @var bool
     */
    public $see_lname;
    /**
     * The see_age
     * @var bool
     */
    public $see_age;
    /**
     * The see_address
     * @var bool
     */
    public $see_address;
    /**
     * The see_phones
     * @var bool
     */
    public $see_phones;
    /**
     * The see_jobrating
     * @var bool
     */
    public $see_jobrating;
    /**
     * The see_timesheets
     * @var bool
     */
    public $see_timesheets;
    /**
     * The can_approve_timesheet
     * @var bool
     */
    public $can_approve_timesheet;
    /**
     * The can_order_shifts
     * @var bool
     */
    public $can_order_shifts;
    /**
     * The can_approve_bookings
     * @var bool
     */
    public $can_approve_bookings;
    /**
     * The see_post_nr
     * @var bool
     */
    public $see_post_nr;
    /**
     * The see_noteblock
     * @var bool
     */
    public $see_noteblock;
    /**
     * The see_qualifications
     * @var bool
     */
    public $see_qualifications;
    /**
     * The see_contacts
     * @var bool
     */
    public $see_contacts;
    /**
     * The create_casehandlers
     * @var bool
     */
    public $create_casehandlers;
    /**
     * The hide_concern_menu
     * @var bool
     */
    public $hide_concern_menu;
    /**
     * The baids
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:int[]
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $baids;
    /**
     * The piids
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:int[]
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $piids;
    /**
     * Constructor method for AxpCustomerContactRaw
     * @uses AxpCustomerContactRaw::setCcid()
     * @uses AxpCustomerContactRaw::setUid()
     * @uses AxpCustomerContactRaw::setCust_id()
     * @uses AxpCustomerContactRaw::setClid()
     * @uses AxpCustomerContactRaw::setUsername()
     * @uses AxpCustomerContactRaw::setPassword()
     * @uses AxpCustomerContactRaw::setFname()
     * @uses AxpCustomerContactRaw::setLname()
     * @uses AxpCustomerContactRaw::setTitle()
     * @uses AxpCustomerContactRaw::setPhone()
     * @uses AxpCustomerContactRaw::setMobile()
     * @uses AxpCustomerContactRaw::setEmail()
     * @uses AxpCustomerContactRaw::setWork_loc()
     * @uses AxpCustomerContactRaw::setSystemmail()
     * @uses AxpCustomerContactRaw::setNote()
     * @uses AxpCustomerContactRaw::setCanrate()
     * @uses AxpCustomerContactRaw::setActive()
     * @uses AxpCustomerContactRaw::setIs_primary()
     * @uses AxpCustomerContactRaw::setLast_auto_notification()
     * @uses AxpCustomerContactRaw::setReceive_timesheet_receipt()
     * @uses AxpCustomerContactRaw::setReport_level()
     * @uses AxpCustomerContactRaw::setNewsletter()
     * @uses AxpCustomerContactRaw::setTimesheet_cc()
     * @uses AxpCustomerContactRaw::setName()
     * @uses AxpCustomerContactRaw::setSee_price()
     * @uses AxpCustomerContactRaw::setSee_salary()
     * @uses AxpCustomerContactRaw::setSee_discount()
     * @uses AxpCustomerContactRaw::setSee_temp()
     * @uses AxpCustomerContactRaw::setSee_fname_plus()
     * @uses AxpCustomerContactRaw::setSee_lname()
     * @uses AxpCustomerContactRaw::setSee_age()
     * @uses AxpCustomerContactRaw::setSee_address()
     * @uses AxpCustomerContactRaw::setSee_phones()
     * @uses AxpCustomerContactRaw::setSee_jobrating()
     * @uses AxpCustomerContactRaw::setSee_timesheets()
     * @uses AxpCustomerContactRaw::setCan_approve_timesheet()
     * @uses AxpCustomerContactRaw::setCan_order_shifts()
     * @uses AxpCustomerContactRaw::setCan_approve_bookings()
     * @uses AxpCustomerContactRaw::setSee_post_nr()
     * @uses AxpCustomerContactRaw::setSee_noteblock()
     * @uses AxpCustomerContactRaw::setSee_qualifications()
     * @uses AxpCustomerContactRaw::setSee_contacts()
     * @uses AxpCustomerContactRaw::setCreate_casehandlers()
     * @uses AxpCustomerContactRaw::setHide_concern_menu()
     * @uses AxpCustomerContactRaw::setBaids()
     * @uses AxpCustomerContactRaw::setPiids()
     * @param int $ccid
     * @param int $uid
     * @param int $cust_id
     * @param int $clid
     * @param string $username
     * @param string $password
     * @param string $fname
     * @param string $lname
     * @param string $title
     * @param string $phone
     * @param string $mobile
     * @param string $email
     * @param int $work_loc
     * @param int $systemmail
     * @param string $note
     * @param int $canrate
     * @param int $active
     * @param int $is_primary
     * @param string $last_auto_notification
     * @param int $receive_timesheet_receipt
     * @param int $report_level
     * @param int $newsletter
     * @param int $timesheet_cc
     * @param string $name
     * @param bool $see_price
     * @param bool $see_salary
     * @param bool $see_discount
     * @param bool $see_temp
     * @param bool $see_fname_plus
     * @param bool $see_lname
     * @param bool $see_age
     * @param bool $see_address
     * @param bool $see_phones
     * @param bool $see_jobrating
     * @param bool $see_timesheets
     * @param bool $can_approve_timesheet
     * @param bool $can_order_shifts
     * @param bool $can_approve_bookings
     * @param bool $see_post_nr
     * @param bool $see_noteblock
     * @param bool $see_qualifications
     * @param bool $see_contacts
     * @param bool $create_casehandlers
     * @param bool $hide_concern_menu
     * @param int[] $baids
     * @param int[] $piids
     */
    public function __construct($ccid = null, $uid = null, $cust_id = null, $clid = null, $username = null, $password = null, $fname = null, $lname = null, $title = null, $phone = null, $mobile = null, $email = null, $work_loc = null, $systemmail = null, $note = null, $canrate = null, $active = null, $is_primary = null, $last_auto_notification = null, $receive_timesheet_receipt = null, $report_level = null, $newsletter = null, $timesheet_cc = null, $name = null, $see_price = null, $see_salary = null, $see_discount = null, $see_temp = null, $see_fname_plus = null, $see_lname = null, $see_age = null, $see_address = null, $see_phones = null, $see_jobrating = null, $see_timesheets = null, $can_approve_timesheet = null, $can_order_shifts = null, $can_approve_bookings = null, $see_post_nr = null, $see_noteblock = null, $see_qualifications = null, $see_contacts = null, $create_casehandlers = null, $hide_concern_menu = null, array $baids = array(), array $piids = array())
    {
        $this
            ->setCcid($ccid)
            ->setUid($uid)
            ->setCust_id($cust_id)
            ->setClid($clid)
            ->setUsername($username)
            ->setPassword($password)
            ->setFname($fname)
            ->setLname($lname)
            ->setTitle($title)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setEmail($email)
            ->setWork_loc($work_loc)
            ->setSystemmail($systemmail)
            ->setNote($note)
            ->setCanrate($canrate)
            ->setActive($active)
            ->setIs_primary($is_primary)
            ->setLast_auto_notification($last_auto_notification)
            ->setReceive_timesheet_receipt($receive_timesheet_receipt)
            ->setReport_level($report_level)
            ->setNewsletter($newsletter)
            ->setTimesheet_cc($timesheet_cc)
            ->setName($name)
            ->setSee_price($see_price)
            ->setSee_salary($see_salary)
            ->setSee_discount($see_discount)
            ->setSee_temp($see_temp)
            ->setSee_fname_plus($see_fname_plus)
            ->setSee_lname($see_lname)
            ->setSee_age($see_age)
            ->setSee_address($see_address)
            ->setSee_phones($see_phones)
            ->setSee_jobrating($see_jobrating)
            ->setSee_timesheets($see_timesheets)
            ->setCan_approve_timesheet($can_approve_timesheet)
            ->setCan_order_shifts($can_order_shifts)
            ->setCan_approve_bookings($can_approve_bookings)
            ->setSee_post_nr($see_post_nr)
            ->setSee_noteblock($see_noteblock)
            ->setSee_qualifications($see_qualifications)
            ->setSee_contacts($see_contacts)
            ->setCreate_casehandlers($create_casehandlers)
            ->setHide_concern_menu($hide_concern_menu)
            ->setBaids($baids)
            ->setPiids($piids);
    }
    /**
     * Get ccid value
     * @return int|null
     */
    public function getCcid()
    {
        return $this->ccid;
    }
    /**
     * Set ccid value
     * @param int $ccid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCcid($ccid = null)
    {
        // validation for constraint: int
        if (!is_null($ccid) && !is_numeric($ccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccid)), __LINE__);
        }
        $this->ccid = $ccid;
        return $this;
    }
    /**
     * Get uid value
     * @return int|null
     */
    public function getUid()
    {
        return $this->uid;
    }
    /**
     * Set uid value
     * @param int $uid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setUid($uid = null)
    {
        // validation for constraint: int
        if (!is_null($uid) && !is_numeric($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uid)), __LINE__);
        }
        $this->uid = $uid;
        return $this;
    }
    /**
     * Get cust_id value
     * @return int|null
     */
    public function getCust_id()
    {
        return $this->cust_id;
    }
    /**
     * Set cust_id value
     * @param int $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCust_id($cust_id = null)
    {
        // validation for constraint: int
        if (!is_null($cust_id) && !is_numeric($cust_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_id)), __LINE__);
        }
        $this->cust_id = $cust_id;
        return $this;
    }
    /**
     * Get clid value
     * @return int|null
     */
    public function getClid()
    {
        return $this->clid;
    }
    /**
     * Set clid value
     * @param int $clid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setClid($clid = null)
    {
        // validation for constraint: int
        if (!is_null($clid) && !is_numeric($clid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clid)), __LINE__);
        }
        $this->clid = $clid;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get fname value
     * @return string|null
     */
    public function getFname()
    {
        return $this->fname;
    }
    /**
     * Set fname value
     * @param string $fname
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setFname($fname = null)
    {
        // validation for constraint: string
        if (!is_null($fname) && !is_string($fname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fname)), __LINE__);
        }
        $this->fname = $fname;
        return $this;
    }
    /**
     * Get lname value
     * @return string|null
     */
    public function getLname()
    {
        return $this->lname;
    }
    /**
     * Set lname value
     * @param string $lname
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setLname($lname = null)
    {
        // validation for constraint: string
        if (!is_null($lname) && !is_string($lname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lname)), __LINE__);
        }
        $this->lname = $lname;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param string $mobile
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobile)), __LINE__);
        }
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get work_loc value
     * @return int|null
     */
    public function getWork_loc()
    {
        return $this->work_loc;
    }
    /**
     * Set work_loc value
     * @param int $work_loc
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setWork_loc($work_loc = null)
    {
        // validation for constraint: int
        if (!is_null($work_loc) && !is_numeric($work_loc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($work_loc)), __LINE__);
        }
        $this->work_loc = $work_loc;
        return $this;
    }
    /**
     * Get systemmail value
     * @return int|null
     */
    public function getSystemmail()
    {
        return $this->systemmail;
    }
    /**
     * Set systemmail value
     * @param int $systemmail
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSystemmail($systemmail = null)
    {
        // validation for constraint: int
        if (!is_null($systemmail) && !is_numeric($systemmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemmail)), __LINE__);
        }
        $this->systemmail = $systemmail;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get canrate value
     * @return int|null
     */
    public function getCanrate()
    {
        return $this->canrate;
    }
    /**
     * Set canrate value
     * @param int $canrate
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCanrate($canrate = null)
    {
        // validation for constraint: int
        if (!is_null($canrate) && !is_numeric($canrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($canrate)), __LINE__);
        }
        $this->canrate = $canrate;
        return $this;
    }
    /**
     * Get active value
     * @return int|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param int $active
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setActive($active = null)
    {
        // validation for constraint: int
        if (!is_null($active) && !is_numeric($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get is_primary value
     * @return int|null
     */
    public function getIs_primary()
    {
        return $this->is_primary;
    }
    /**
     * Set is_primary value
     * @param int $is_primary
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setIs_primary($is_primary = null)
    {
        // validation for constraint: int
        if (!is_null($is_primary) && !is_numeric($is_primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_primary)), __LINE__);
        }
        $this->is_primary = $is_primary;
        return $this;
    }
    /**
     * Get last_auto_notification value
     * @return string|null
     */
    public function getLast_auto_notification()
    {
        return $this->last_auto_notification;
    }
    /**
     * Set last_auto_notification value
     * @param string $last_auto_notification
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setLast_auto_notification($last_auto_notification = null)
    {
        // validation for constraint: string
        if (!is_null($last_auto_notification) && !is_string($last_auto_notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_auto_notification)), __LINE__);
        }
        $this->last_auto_notification = $last_auto_notification;
        return $this;
    }
    /**
     * Get receive_timesheet_receipt value
     * @return int|null
     */
    public function getReceive_timesheet_receipt()
    {
        return $this->receive_timesheet_receipt;
    }
    /**
     * Set receive_timesheet_receipt value
     * @param int $receive_timesheet_receipt
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setReceive_timesheet_receipt($receive_timesheet_receipt = null)
    {
        // validation for constraint: int
        if (!is_null($receive_timesheet_receipt) && !is_numeric($receive_timesheet_receipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receive_timesheet_receipt)), __LINE__);
        }
        $this->receive_timesheet_receipt = $receive_timesheet_receipt;
        return $this;
    }
    /**
     * Get report_level value
     * @return int|null
     */
    public function getReport_level()
    {
        return $this->report_level;
    }
    /**
     * Set report_level value
     * @param int $report_level
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setReport_level($report_level = null)
    {
        // validation for constraint: int
        if (!is_null($report_level) && !is_numeric($report_level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($report_level)), __LINE__);
        }
        $this->report_level = $report_level;
        return $this;
    }
    /**
     * Get newsletter value
     * @return int|null
     */
    public function getNewsletter()
    {
        return $this->newsletter;
    }
    /**
     * Set newsletter value
     * @param int $newsletter
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setNewsletter($newsletter = null)
    {
        // validation for constraint: int
        if (!is_null($newsletter) && !is_numeric($newsletter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newsletter)), __LINE__);
        }
        $this->newsletter = $newsletter;
        return $this;
    }
    /**
     * Get timesheet_cc value
     * @return int|null
     */
    public function getTimesheet_cc()
    {
        return $this->timesheet_cc;
    }
    /**
     * Set timesheet_cc value
     * @param int $timesheet_cc
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setTimesheet_cc($timesheet_cc = null)
    {
        // validation for constraint: int
        if (!is_null($timesheet_cc) && !is_numeric($timesheet_cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timesheet_cc)), __LINE__);
        }
        $this->timesheet_cc = $timesheet_cc;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get see_price value
     * @return bool|null
     */
    public function getSee_price()
    {
        return $this->see_price;
    }
    /**
     * Set see_price value
     * @param bool $see_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_price($see_price = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_price) && !is_bool($see_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_price)), __LINE__);
        }
        $this->see_price = $see_price;
        return $this;
    }
    /**
     * Get see_salary value
     * @return bool|null
     */
    public function getSee_salary()
    {
        return $this->see_salary;
    }
    /**
     * Set see_salary value
     * @param bool $see_salary
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_salary($see_salary = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_salary) && !is_bool($see_salary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_salary)), __LINE__);
        }
        $this->see_salary = $see_salary;
        return $this;
    }
    /**
     * Get see_discount value
     * @return bool|null
     */
    public function getSee_discount()
    {
        return $this->see_discount;
    }
    /**
     * Set see_discount value
     * @param bool $see_discount
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_discount($see_discount = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_discount) && !is_bool($see_discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_discount)), __LINE__);
        }
        $this->see_discount = $see_discount;
        return $this;
    }
    /**
     * Get see_temp value
     * @return bool|null
     */
    public function getSee_temp()
    {
        return $this->see_temp;
    }
    /**
     * Set see_temp value
     * @param bool $see_temp
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_temp($see_temp = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_temp) && !is_bool($see_temp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_temp)), __LINE__);
        }
        $this->see_temp = $see_temp;
        return $this;
    }
    /**
     * Get see_fname_plus value
     * @return bool|null
     */
    public function getSee_fname_plus()
    {
        return $this->see_fname_plus;
    }
    /**
     * Set see_fname_plus value
     * @param bool $see_fname_plus
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_fname_plus($see_fname_plus = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_fname_plus) && !is_bool($see_fname_plus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_fname_plus)), __LINE__);
        }
        $this->see_fname_plus = $see_fname_plus;
        return $this;
    }
    /**
     * Get see_lname value
     * @return bool|null
     */
    public function getSee_lname()
    {
        return $this->see_lname;
    }
    /**
     * Set see_lname value
     * @param bool $see_lname
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_lname($see_lname = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_lname) && !is_bool($see_lname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_lname)), __LINE__);
        }
        $this->see_lname = $see_lname;
        return $this;
    }
    /**
     * Get see_age value
     * @return bool|null
     */
    public function getSee_age()
    {
        return $this->see_age;
    }
    /**
     * Set see_age value
     * @param bool $see_age
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_age($see_age = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_age) && !is_bool($see_age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_age)), __LINE__);
        }
        $this->see_age = $see_age;
        return $this;
    }
    /**
     * Get see_address value
     * @return bool|null
     */
    public function getSee_address()
    {
        return $this->see_address;
    }
    /**
     * Set see_address value
     * @param bool $see_address
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_address($see_address = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_address) && !is_bool($see_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_address)), __LINE__);
        }
        $this->see_address = $see_address;
        return $this;
    }
    /**
     * Get see_phones value
     * @return bool|null
     */
    public function getSee_phones()
    {
        return $this->see_phones;
    }
    /**
     * Set see_phones value
     * @param bool $see_phones
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_phones($see_phones = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_phones) && !is_bool($see_phones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_phones)), __LINE__);
        }
        $this->see_phones = $see_phones;
        return $this;
    }
    /**
     * Get see_jobrating value
     * @return bool|null
     */
    public function getSee_jobrating()
    {
        return $this->see_jobrating;
    }
    /**
     * Set see_jobrating value
     * @param bool $see_jobrating
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_jobrating($see_jobrating = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_jobrating) && !is_bool($see_jobrating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_jobrating)), __LINE__);
        }
        $this->see_jobrating = $see_jobrating;
        return $this;
    }
    /**
     * Get see_timesheets value
     * @return bool|null
     */
    public function getSee_timesheets()
    {
        return $this->see_timesheets;
    }
    /**
     * Set see_timesheets value
     * @param bool $see_timesheets
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_timesheets($see_timesheets = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_timesheets) && !is_bool($see_timesheets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_timesheets)), __LINE__);
        }
        $this->see_timesheets = $see_timesheets;
        return $this;
    }
    /**
     * Get can_approve_timesheet value
     * @return bool|null
     */
    public function getCan_approve_timesheet()
    {
        return $this->can_approve_timesheet;
    }
    /**
     * Set can_approve_timesheet value
     * @param bool $can_approve_timesheet
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCan_approve_timesheet($can_approve_timesheet = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_approve_timesheet) && !is_bool($can_approve_timesheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_approve_timesheet)), __LINE__);
        }
        $this->can_approve_timesheet = $can_approve_timesheet;
        return $this;
    }
    /**
     * Get can_order_shifts value
     * @return bool|null
     */
    public function getCan_order_shifts()
    {
        return $this->can_order_shifts;
    }
    /**
     * Set can_order_shifts value
     * @param bool $can_order_shifts
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCan_order_shifts($can_order_shifts = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_order_shifts) && !is_bool($can_order_shifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_order_shifts)), __LINE__);
        }
        $this->can_order_shifts = $can_order_shifts;
        return $this;
    }
    /**
     * Get can_approve_bookings value
     * @return bool|null
     */
    public function getCan_approve_bookings()
    {
        return $this->can_approve_bookings;
    }
    /**
     * Set can_approve_bookings value
     * @param bool $can_approve_bookings
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCan_approve_bookings($can_approve_bookings = null)
    {
        // validation for constraint: boolean
        if (!is_null($can_approve_bookings) && !is_bool($can_approve_bookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($can_approve_bookings)), __LINE__);
        }
        $this->can_approve_bookings = $can_approve_bookings;
        return $this;
    }
    /**
     * Get see_post_nr value
     * @return bool|null
     */
    public function getSee_post_nr()
    {
        return $this->see_post_nr;
    }
    /**
     * Set see_post_nr value
     * @param bool $see_post_nr
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_post_nr($see_post_nr = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_post_nr) && !is_bool($see_post_nr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_post_nr)), __LINE__);
        }
        $this->see_post_nr = $see_post_nr;
        return $this;
    }
    /**
     * Get see_noteblock value
     * @return bool|null
     */
    public function getSee_noteblock()
    {
        return $this->see_noteblock;
    }
    /**
     * Set see_noteblock value
     * @param bool $see_noteblock
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_noteblock($see_noteblock = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_noteblock) && !is_bool($see_noteblock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_noteblock)), __LINE__);
        }
        $this->see_noteblock = $see_noteblock;
        return $this;
    }
    /**
     * Get see_qualifications value
     * @return bool|null
     */
    public function getSee_qualifications()
    {
        return $this->see_qualifications;
    }
    /**
     * Set see_qualifications value
     * @param bool $see_qualifications
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_qualifications($see_qualifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_qualifications) && !is_bool($see_qualifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_qualifications)), __LINE__);
        }
        $this->see_qualifications = $see_qualifications;
        return $this;
    }
    /**
     * Get see_contacts value
     * @return bool|null
     */
    public function getSee_contacts()
    {
        return $this->see_contacts;
    }
    /**
     * Set see_contacts value
     * @param bool $see_contacts
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setSee_contacts($see_contacts = null)
    {
        // validation for constraint: boolean
        if (!is_null($see_contacts) && !is_bool($see_contacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($see_contacts)), __LINE__);
        }
        $this->see_contacts = $see_contacts;
        return $this;
    }
    /**
     * Get create_casehandlers value
     * @return bool|null
     */
    public function getCreate_casehandlers()
    {
        return $this->create_casehandlers;
    }
    /**
     * Set create_casehandlers value
     * @param bool $create_casehandlers
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setCreate_casehandlers($create_casehandlers = null)
    {
        // validation for constraint: boolean
        if (!is_null($create_casehandlers) && !is_bool($create_casehandlers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($create_casehandlers)), __LINE__);
        }
        $this->create_casehandlers = $create_casehandlers;
        return $this;
    }
    /**
     * Get hide_concern_menu value
     * @return bool|null
     */
    public function getHide_concern_menu()
    {
        return $this->hide_concern_menu;
    }
    /**
     * Set hide_concern_menu value
     * @param bool $hide_concern_menu
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setHide_concern_menu($hide_concern_menu = null)
    {
        // validation for constraint: boolean
        if (!is_null($hide_concern_menu) && !is_bool($hide_concern_menu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hide_concern_menu)), __LINE__);
        }
        $this->hide_concern_menu = $hide_concern_menu;
        return $this;
    }
    /**
     * Get baids value
     * @return int[]|null
     */
    public function getBaids()
    {
        return $this->baids;
    }
    /**
     * Set baids value
     * @throws \InvalidArgumentException
     * @param int[] $baids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setBaids(array $baids = array())
    {
        foreach ($baids as $axpCustomerContactRawBaidsItem) {
            // validation for constraint: itemType
            if (!is_numeric($axpCustomerContactRawBaidsItem)) {
                throw new \InvalidArgumentException(sprintf('The baids property can only contain items of int, "%s" given', is_object($axpCustomerContactRawBaidsItem) ? get_class($axpCustomerContactRawBaidsItem) : gettype($axpCustomerContactRawBaidsItem)), __LINE__);
            }
        }
        $this->baids = $baids;
        return $this;
    }
    /**
     * Add item to baids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function addToBaids($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The baids property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->baids[] = $item;
        return $this;
    }
    /**
     * Get piids value
     * @return int[]|null
     */
    public function getPiids()
    {
        return $this->piids;
    }
    /**
     * Set piids value
     * @throws \InvalidArgumentException
     * @param int[] $piids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function setPiids(array $piids = array())
    {
        foreach ($piids as $axpCustomerContactRawPiidsItem) {
            // validation for constraint: itemType
            if (!is_numeric($axpCustomerContactRawPiidsItem)) {
                throw new \InvalidArgumentException(sprintf('The piids property can only contain items of int, "%s" given', is_object($axpCustomerContactRawPiidsItem) ? get_class($axpCustomerContactRawPiidsItem) : gettype($axpCustomerContactRawPiidsItem)), __LINE__);
            }
        }
        $this->piids = $piids;
        return $this;
    }
    /**
     * Add item to piids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public function addToPiids($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The piids property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->piids[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
