<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpContract StructType
 * @subpackage Structs
 */
class AxpContract extends AbstractStructBase
{
    /**
     * The cid
     * @var int
     */
    public $cid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The descr
     * @var string
     */
    public $descr;
    /**
     * The validfrom
     * @var string
     */
    public $validfrom;
    /**
     * The validto
     * @var string
     */
    public $validto;
    /**
     * The next
     * @var int
     */
    public $next;
    /**
     * The plaintext
     * @var string
     */
    public $plaintext;
    /**
     * The default_parmgroup
     * @var string
     */
    public $default_parmgroup;
    /**
     * Constructor method for AxpContract
     * @uses AxpContract::setCid()
     * @uses AxpContract::setLabel()
     * @uses AxpContract::setDescr()
     * @uses AxpContract::setValidfrom()
     * @uses AxpContract::setValidto()
     * @uses AxpContract::setNext()
     * @uses AxpContract::setPlaintext()
     * @uses AxpContract::setDefault_parmgroup()
     * @param int $cid
     * @param string $label
     * @param string $descr
     * @param string $validfrom
     * @param string $validto
     * @param int $next
     * @param string $plaintext
     * @param string $default_parmgroup
     */
    public function __construct($cid = null, $label = null, $descr = null, $validfrom = null, $validto = null, $next = null, $plaintext = null, $default_parmgroup = null)
    {
        $this
            ->setCid($cid)
            ->setLabel($label)
            ->setDescr($descr)
            ->setValidfrom($validfrom)
            ->setValidto($validto)
            ->setNext($next)
            ->setPlaintext($plaintext)
            ->setDefault_parmgroup($default_parmgroup);
    }
    /**
     * Get cid value
     * @return int|null
     */
    public function getCid()
    {
        return $this->cid;
    }
    /**
     * Set cid value
     * @param int $cid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setCid($cid = null)
    {
        // validation for constraint: int
        if (!is_null($cid) && !is_numeric($cid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cid)), __LINE__);
        }
        $this->cid = $cid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get descr value
     * @return string|null
     */
    public function getDescr()
    {
        return $this->descr;
    }
    /**
     * Set descr value
     * @param string $descr
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setDescr($descr = null)
    {
        // validation for constraint: string
        if (!is_null($descr) && !is_string($descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descr)), __LINE__);
        }
        $this->descr = $descr;
        return $this;
    }
    /**
     * Get validfrom value
     * @return string|null
     */
    public function getValidfrom()
    {
        return $this->validfrom;
    }
    /**
     * Set validfrom value
     * @param string $validfrom
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setValidfrom($validfrom = null)
    {
        // validation for constraint: string
        if (!is_null($validfrom) && !is_string($validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validfrom)), __LINE__);
        }
        $this->validfrom = $validfrom;
        return $this;
    }
    /**
     * Get validto value
     * @return string|null
     */
    public function getValidto()
    {
        return $this->validto;
    }
    /**
     * Set validto value
     * @param string $validto
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setValidto($validto = null)
    {
        // validation for constraint: string
        if (!is_null($validto) && !is_string($validto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validto)), __LINE__);
        }
        $this->validto = $validto;
        return $this;
    }
    /**
     * Get next value
     * @return int|null
     */
    public function getNext()
    {
        return $this->next;
    }
    /**
     * Set next value
     * @param int $next
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setNext($next = null)
    {
        // validation for constraint: int
        if (!is_null($next) && !is_numeric($next)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($next)), __LINE__);
        }
        $this->next = $next;
        return $this;
    }
    /**
     * Get plaintext value
     * @return string|null
     */
    public function getPlaintext()
    {
        return $this->plaintext;
    }
    /**
     * Set plaintext value
     * @param string $plaintext
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setPlaintext($plaintext = null)
    {
        // validation for constraint: string
        if (!is_null($plaintext) && !is_string($plaintext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaintext)), __LINE__);
        }
        $this->plaintext = $plaintext;
        return $this;
    }
    /**
     * Get default_parmgroup value
     * @return string|null
     */
    public function getDefault_parmgroup()
    {
        return $this->default_parmgroup;
    }
    /**
     * Set default_parmgroup value
     * @param string $default_parmgroup
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public function setDefault_parmgroup($default_parmgroup = null)
    {
        // validation for constraint: string
        if (!is_null($default_parmgroup) && !is_string($default_parmgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_parmgroup)), __LINE__);
        }
        $this->default_parmgroup = $default_parmgroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
