<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importBridgeTemp
     * Meta informations extracted from the WSDL
     * - documentation: Import a temp from bridge to AXP. If temp already exists with a matching CPR number, it will be updated using the supplied data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw $axpTemp
     * @param string $operationType
     * @return int|bool
     */
    public function importBridgeTemp($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw $axpTemp, $operationType)
    {
        try {
            $this->setResult(self::getSoapClient()->importBridgeTemp($handle, $axpTemp, $operationType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importBridgeCalendar
     * Meta informations extracted from the WSDL
     * - documentation: Import a calendar item for a given candidate, identified via cpr number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cpr
     * @param string $from
     * @param string $to
     * @param string $kind
     * @param string $remarks
     * @return boolean|bool
     */
    public function importBridgeCalendar($handle, $cpr, $from, $to, $kind, $remarks)
    {
        try {
            $this->setResult(self::getSoapClient()->importBridgeCalendar($handle, $cpr, $from, $to, $kind, $remarks));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|int
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
