<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getHandle
     * Meta informations extracted from the WSDL
     * - documentation: Get required handle for further use of this service
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @return string|bool
     */
    public function getHandle($username, $password)
    {
        try {
            $this->setResult(self::getSoapClient()->getHandle($username, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomer
     * Meta informations extracted from the WSDL
     * - documentation: Get all details about a given customer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer|bool
     */
    public function getCustomer($handle, $cust_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomer($handle, $cust_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContact
     * Meta informations extracted from the WSDL
     * - documentation: Get all details about a given customer contact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $uid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContact|bool
     */
    public function getContact($handle, $uid)
    {
        try {
            $this->setResult(self::getSoapClient()->getContact($handle, $uid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getC5ProjectList
     * Meta informations extracted from the WSDL
     * - documentation: Returns project data, for all open orders with one or more assigned temps for the given day (ISO 8601).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject[]|bool
     */
    public function getC5ProjectList($handle, $date)
    {
        try {
            $this->setResult(self::getSoapClient()->getC5ProjectList($handle, $date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getC5ArchivedProjectList
     * Meta informations extracted from the WSDL
     * - documentation: Returns project data, for all archived orders with one or more assigned temps for the given day (ISO 8601).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject[]|bool
     */
    public function getC5ArchivedProjectList($handle, $date)
    {
        try {
            $this->setResult(self::getSoapClient()->getC5ArchivedProjectList($handle, $date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpCustomerRawList
     * Meta informations extracted from the WSDL
     * - documentation: Returns unmapped AxpCustomers (The RAW version) if found. All search-parameters should be sent, and in specified order, and left empty if non-important. Date formats are ISO 8601. SQL pattern matching can be used in the "company"
     * parameter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $company
     * @param string $company_id_from
     * @param string $company_id_to
     * @param string $created_before
     * @param string $created_after
     * @param string $internal_id_from
     * @param string $internal_id_to
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw[]|bool
     */
    public function getAxpCustomerRawList($handle, $company, $company_id_from, $company_id_to, $created_before, $created_after, $internal_id_from, $internal_id_to)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpCustomerRawList($handle, $company, $company_id_from, $company_id_to, $created_before, $created_after, $internal_id_from, $internal_id_to));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpCustIdFromCustNo
     * Meta informations extracted from the WSDL
     * - documentation: Returns internal customer id (cust_id), from external customer number (cust_no).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_no
     * @return int|bool
     */
    public function getAxpCustIdFromCustNo($handle, $cust_no)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpCustIdFromCustNo($handle, $cust_no));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpCustomerContactList
     * Meta informations extracted from the WSDL
     * - documentation: Returns all AxpCustomerContact from a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw[]|bool
     */
    public function getAxpCustomerContactList($handle, $cust_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpCustomerContactList($handle, $cust_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpBusinessAreaList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available business areas. baids can be used to fetch only specific business areas.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $baids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea[]|bool
     */
    public function getAxpBusinessAreaList($handle, $baids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpBusinessAreaList($handle, $baids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpDepartmentList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available departments. dids can be used to fetch only specific departments.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $dids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpDepartment[]|bool
     */
    public function getAxpDepartmentList($handle, $dids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpDepartmentList($handle, $dids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpErpSegmentList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available erp segments. esids can be used to fetch only specific segments.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $esids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpErpSegment[]|bool
     */
    public function getAxpErpSegmentList($handle, $esids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpErpSegmentList($handle, $esids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpPersonalInterestList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available personal interests. piids can be used to fetch only specific interests.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $piids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpPersonalInterest[]|bool
     */
    public function getAxpPersonalInterestList($handle, $piids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpPersonalInterestList($handle, $piids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getErpGuestDataList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available erp guest data. fieldIds can be used to fetch only specific erp guest data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $fieldIds
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\ErpGuestData[]|bool
     */
    public function getErpGuestDataList($handle, $fieldIds)
    {
        try {
            $this->setResult(self::getSoapClient()->getErpGuestDataList($handle, $fieldIds));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpActivityTypeList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available activity/note-types. aids can be used to fetch only specific types.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $aids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpActivityType[]|bool
     */
    public function getAxpActivityTypeList($handle, $aids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpActivityTypeList($handle, $aids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpFieldOfWorkList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available work-fields. fids can be used to fetch only specific fields.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $fids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpFieldOfWork[]|bool
     */
    public function getAxpFieldOfWorkList($handle, $fids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpFieldOfWorkList($handle, $fids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpCompanyFormList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of available company forms. cfids can be used to fetch only specific forms.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cfids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCompanyForm[]|bool
     */
    public function getAxpCompanyFormList($handle, $cfids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpCompanyFormList($handle, $cfids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpTempRawList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of matching AxpTemps (Raw version). Date formats are ISO 8601. SQL pattern matching can be used in the "label" parameter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $tids
     * @param string $label
     * @param string $classifications
     * @param string $created_before
     * @param string $created_after
     * @param string $cpr
     * @param string $baids
     * @param string $updated_before
     * @param string $updated_after
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw[]|bool
     */
    public function getAxpTempRawList($handle, $tids, $label, $classifications, $created_before, $created_after, $cpr, $baids, $updated_before, $updated_after)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpTempRawList($handle, $tids, $label, $classifications, $created_before, $created_after, $cpr, $baids, $updated_before, $updated_after));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpTidFromLabel
     * Meta informations extracted from the WSDL
     * - documentation: Returns internal temp id (tid), from external temp label (label).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $label
     * @return int|bool
     */
    public function getAxpTidFromLabel($handle, $label)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpTidFromLabel($handle, $label));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpTempSkillList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of matching AxpTemp skills.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $tid
     * @return array|bool
     */
    public function getAxpTempSkillList($handle, $tid)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpTempSkillList($handle, $tid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpTempBizareaList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of matching AxpTemp business areas.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $tid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempBizareas[]|bool
     */
    public function getAxpTempBizareaList($handle, $tid)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpTempBizareaList($handle, $tid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpConsultantList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of all consultants.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpConsultant[]|bool
     */
    public function getAxpConsultantList($handle)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpConsultantList($handle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpCustomerGroupList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of customergroups.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cgids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerGroup[]|bool
     */
    public function getAxpCustomerGroupList($handle, $cgids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpCustomerGroupList($handle, $cgids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpOrderList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of orders by array of internal order ids, company name or customer number. Will return all orders if empty array given.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $orids
     * @param string $company
     * @param string $cust_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder[]|bool
     */
    public function getAxpOrderList($handle, $orids, $company, $cust_no)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpOrderList($handle, $orids, $company, $cust_no));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpOridFromOrderId
     * Meta informations extracted from the WSDL
     * - documentation: Returns internal order id (orid), from external order id (order_id).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $order_id
     * @return int|bool
     */
    public function getAxpOridFromOrderId($handle, $order_id)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpOridFromOrderId($handle, $order_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpOrderTempList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of temps on orders by array of internal order ids.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $orids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw[]|bool
     */
    public function getAxpOrderTempList($handle, $orids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpOrderTempList($handle, $orids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpOrderLineList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of orders lines by internal order or/and by internal order line id. Will return all order lines if no params given
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $olids
     * @param string $orids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrderLine[]|bool
     */
    public function getAxpOrderLineList($handle, $olids, $orids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpOrderLineList($handle, $olids, $orids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpContractList
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of contracts specified by array of contract ids. Empty array will return all contracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract[]|bool
     */
    public function getAxpContractList($handle, $cids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpContractList($handle, $cids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpBookings
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of bookings in a specified date-range. Empty dates will return all bookings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $from_date
     * @param string $to_date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking[]|bool
     */
    public function getAxpBookings($handle, $from_date, $to_date)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpBookings($handle, $from_date, $to_date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpAreas
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list AxpAreas, aids can be used to return only specific areas.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $aids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea[]|bool
     */
    public function getAxpAreas($handle, $aids)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpAreas($handle, $aids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpNotes
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of all AxpNotes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpNote[]|bool
     */
    public function getAxpNotes($handle)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpNotes($handle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAxpNationalities
     * Meta informations extracted from the WSDL
     * - documentation: Returns a list of all AxpNationalities.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpNationality[]|bool
     */
    public function getAxpNationalities($handle)
    {
        try {
            $this->setResult(self::getSoapClient()->getAxpNationalities($handle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|int|string|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpActivityType[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBooking[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpBusinessArea[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCompanyForm[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpConsultant[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpContract[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContact|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerGroup[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpDepartment[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpErpSegment[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpFieldOfWork[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpNationality[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpNote[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrderLine[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpOrder[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpPersonalInterest[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpProject[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempBizareas[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempRaw[]|\App\ExternalApis\ConsendoAxp\Soap\StructType\ErpGuestData[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
