<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Debug ServiceType
 * @subpackage Services
 */
class Debug extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named debug
     * Meta informations extracted from the WSDL
     * - documentation: Debug: returns data it receives
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $data
     * @return string|bool
     */
    public function debug($data)
    {
        try {
            $this->setResult(self::getSoapClient()->debug($data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
