<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createCustomer
     * Meta informations extracted from the WSDL
     * - documentation: Creates a customer in the AXP system and returns the cust_id to be used for further manipulation of the customer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_no
     * @param string $company
     * @param string $addr1
     * @param string $addr2
     * @param string $zip
     * @param string $city
     * @param string $company_no
     * @param string $employees
     * @param string $phone
     * @param string $phone2
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param string $active
     * @param string $customergroup
     * @param string $discount
     * @param string $consultant
     * @param string $secondary_consultant
     * @param \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString $departments
     * @param string $notes
     * @param string $partners_agreement
     * @param string $partners_agreement_end
     * @param string $customergroup_id
     * @return int|bool
     */
    public function createCustomer($handle, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, \App\ExternalApis\ConsendoAxp\Soap\ArrayType\ArrayOfString $departments, $notes, $partners_agreement, $partners_agreement_end, $customergroup_id)
    {
        try {
            $this->setResult(self::getSoapClient()->createCustomer($handle, $cust_no, $company, $addr1, $addr2, $zip, $city, $company_no, $employees, $phone, $phone2, $fax, $email, $homepage, $active, $customergroup, $discount, $consultant, $secondary_consultant, $departments, $notes, $partners_agreement, $partners_agreement_end, $customergroup_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createContact
     * Meta informations extracted from the WSDL
     * - documentation: Creates a customer contact in the AXP system and returns the uid to be used for further manipulation of the contact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $cust_id
     * @param string $cust_no
     * @param string $fname
     * @param string $lname
     * @param string $title
     * @param string $email
     * @param string $phone
     * @param string $mobile
     * @param string $active
     * @param string $is_primary
     * @return array|bool
     */
    public function createContact($handle, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary)
    {
        try {
            $this->setResult(self::getSoapClient()->createContact($handle, $cust_id, $cust_no, $fname, $lname, $title, $email, $phone, $mobile, $active, $is_primary));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAxpCustomer
     * Meta informations extracted from the WSDL
     * - documentation: create customer, cust_id is ignored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw $customer
     * @return string|bool
     */
    public function createAxpCustomer($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw $customer)
    {
        try {
            $this->setResult(self::getSoapClient()->createAxpCustomer($handle, $customer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAxpCustomerContact
     * Meta informations extracted from the WSDL
     * - documentation: create customer contact, ccid is ignored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw $contact
     * @return int|bool
     */
    public function createAxpCustomerContact($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerContactRaw $contact)
    {
        try {
            $this->setResult(self::getSoapClient()->createAxpCustomerContact($handle, $contact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAxpTempOrder
     * Meta informations extracted from the WSDL
     * - documentation: create new temp order, orid, status and type will be ignored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder $order
     * @return int|bool
     */
    public function createAxpTempOrder($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder $order)
    {
        try {
            $this->setResult(self::getSoapClient()->createAxpTempOrder($handle, $order));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|int|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
