<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clock ServiceType
 * @subpackage Services
 */
class Clock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named clockStampclock
     * Meta informations extracted from the WSDL
     * - documentation: Clocks a temp in/out from work/break using the stampclock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $data
     * @return array|bool
     */
    public function clockStampclock($handle, $data)
    {
        try {
            $this->setResult(self::getSoapClient()->clockStampclock($handle, $data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
