<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Book ServiceType
 * @subpackage Services
 */
class Book extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bookTempOnShift
     * Meta informations extracted from the WSDL
     * - documentation: Book temp on specified shift and extend temp period if needed, can overwrite registrations. break_hours is only informative
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData $shiftData
     * @return boolean|bool
     */
    public function bookTempOnShift($handle, \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpShiftData $shiftData)
    {
        try {
            $this->setResult(self::getSoapClient()->bookTempOnShift($handle, $shiftData));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named bookTempOnOrder
     * Meta informations extracted from the WSDL
     * - documentation: Book a temp on an order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $orid
     * @param string $tid
     * @param string $from_date
     * @param string $to_date
     * @return boolean|bool
     */
    public function bookTempOnOrder($handle, $orid, $tid, $from_date, $to_date)
    {
        try {
            $this->setResult(self::getSoapClient()->bookTempOnOrder($handle, $orid, $tid, $from_date, $to_date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
