<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Approve ServiceType
 * @subpackage Services
 */
class Approve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named approveWeekAsCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $monday
     * @param string $orid
     * @param string $tid
     * @return boolean|bool
     */
    public function approveWeekAsCustomer($handle, $monday, $orid, $tid)
    {
        try {
            $this->setResult(self::getSoapClient()->approveWeekAsCustomer($handle, $monday, $orid, $tid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named approveWeekAsTemp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $monday
     * @param string $orid
     * @param string $tid
     * @return boolean|bool
     */
    public function approveWeekAsTemp($handle, $monday, $orid, $tid)
    {
        try {
            $this->setResult(self::getSoapClient()->approveWeekAsTemp($handle, $monday, $orid, $tid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
