<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adjust ServiceType
 * @subpackage Services
 */
class Adjust extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adjustOrderTimesheet
     * Meta informations extracted from the WSDL
     * - documentation: Adjust timesheets settings, and create new shift if they dont exists in order range
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $temp_label
     * @param string $order_id
     * @param string $title
     * @param string $comment
     * @param string $shift_data
     * @return array|bool
     */
    public function adjustOrderTimesheet($handle, $temp_label, $order_id, $title, $comment, $shift_data)
    {
        try {
            $this->setResult(self::getSoapClient()->adjustOrderTimesheet($handle, $temp_label, $order_id, $title, $comment, $shift_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
