<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpTempOrder StructType
 * @subpackage Structs
 */
class AxpTempOrder extends AbstractStructBase
{
    /**
     * The order_id
     * @var string
     */
    public $order_id;
    /**
     * The cid
     * @var int
     */
    public $cid;
    /**
     * The cust_id
     * @var int
     */
    public $cust_id;
    /**
     * The ccid
     * @var int
     */
    public $ccid;
    /**
     * The did
     * @var int
     */
    public $did;
    /**
     * The received
     * @var string
     */
    public $received;
    /**
     * The bizarea
     * @var int
     */
    public $bizarea;
    /**
     * The location
     * @var int
     */
    public $location;
    /**
     * The from_date
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * @var string
     */
    public $to_date;
    /**
     * The billing_ccid
     * @var int
     */
    public $billing_ccid;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The from_time
     * @var string
     */
    public $from_time;
    /**
     * The to_time
     * @var string
     */
    public $to_time;
    /**
     * The first_time
     * @var string
     */
    public $first_time;
    /**
     * The friday_time
     * @var string
     */
    public $friday_time;
    /**
     * The reference
     * @var string
     */
    public $reference;
    /**
     * The order_key
     * @var string
     */
    public $order_key;
    /**
     * The use_order_key
     * @var bool
     */
    public $use_order_key;
    /**
     * The planned_break
     * @var float
     */
    public $planned_break;
    /**
     * The efaktura_ean_invoice
     * @var string
     */
    public $efaktura_ean_invoice;
    /**
     * The efaktura_ean_delivery
     * @var string
     */
    public $efaktura_ean_delivery;
    /**
     * The efaktura_orderno
     * @var string
     */
    public $efaktura_orderno;
    /**
     * The efaktura_account
     * @var string
     */
    public $efaktura_account;
    /**
     * The payment_customer
     * @var int
     */
    public $payment_customer;
    /**
     * The required_temps
     * @var int
     */
    public $required_temps;
    /**
     * The budget_invoice_price
     * @var float
     */
    public $budget_invoice_price;
    /**
     * The budget_payment_price
     * @var float
     */
    public $budget_payment_price;
    /**
     * The global_location
     * @var int
     */
    public $global_location;
    /**
     * The status_code
     * @var int
     */
    public $status_code;
    /**
     * The sdid
     * @var int
     */
    public $sdid;
    /**
     * The intern_note
     * @var string
     */
    public $intern_note;
    /**
     * The dont_book_holidays
     * @var bool
     */
    public $dont_book_holidays;
    /**
     * The manual_location
     * @var string
     */
    public $manual_location;
    /**
     * The manual_address
     * @var string
     */
    public $manual_address;
    /**
     * The manual_zip_city
     * @var string
     */
    public $manual_zip_city;
    /**
     * The manual_transport_info
     * @var string
     */
    public $manual_transport_info;
    /**
     * The manual_area
     * @var int
     */
    public $manual_area;
    /**
     * The manual_phone
     * @var string
     */
    public $manual_phone;
    /**
     * The custom_timesheet_recipient
     * @var int
     */
    public $custom_timesheet_recipient;
    /**
     * The contract
     * @var int
     */
    public $contract;
    /**
     * The customer_consultant
     * @var int
     */
    public $customer_consultant;
    /**
     * Constructor method for AxpTempOrder
     * @uses AxpTempOrder::setOrder_id()
     * @uses AxpTempOrder::setCid()
     * @uses AxpTempOrder::setCust_id()
     * @uses AxpTempOrder::setCcid()
     * @uses AxpTempOrder::setDid()
     * @uses AxpTempOrder::setReceived()
     * @uses AxpTempOrder::setBizarea()
     * @uses AxpTempOrder::setLocation()
     * @uses AxpTempOrder::setFrom_date()
     * @uses AxpTempOrder::setTo_date()
     * @uses AxpTempOrder::setBilling_ccid()
     * @uses AxpTempOrder::setDescription()
     * @uses AxpTempOrder::setFrom_time()
     * @uses AxpTempOrder::setTo_time()
     * @uses AxpTempOrder::setFirst_time()
     * @uses AxpTempOrder::setFriday_time()
     * @uses AxpTempOrder::setReference()
     * @uses AxpTempOrder::setOrder_key()
     * @uses AxpTempOrder::setUse_order_key()
     * @uses AxpTempOrder::setPlanned_break()
     * @uses AxpTempOrder::setEfaktura_ean_invoice()
     * @uses AxpTempOrder::setEfaktura_ean_delivery()
     * @uses AxpTempOrder::setEfaktura_orderno()
     * @uses AxpTempOrder::setEfaktura_account()
     * @uses AxpTempOrder::setPayment_customer()
     * @uses AxpTempOrder::setRequired_temps()
     * @uses AxpTempOrder::setBudget_invoice_price()
     * @uses AxpTempOrder::setBudget_payment_price()
     * @uses AxpTempOrder::setGlobal_location()
     * @uses AxpTempOrder::setStatus_code()
     * @uses AxpTempOrder::setSdid()
     * @uses AxpTempOrder::setIntern_note()
     * @uses AxpTempOrder::setDont_book_holidays()
     * @uses AxpTempOrder::setManual_location()
     * @uses AxpTempOrder::setManual_address()
     * @uses AxpTempOrder::setManual_zip_city()
     * @uses AxpTempOrder::setManual_transport_info()
     * @uses AxpTempOrder::setManual_area()
     * @uses AxpTempOrder::setManual_phone()
     * @uses AxpTempOrder::setCustom_timesheet_recipient()
     * @uses AxpTempOrder::setContract()
     * @uses AxpTempOrder::setCustomer_consultant()
     * @param string $order_id
     * @param int $cid
     * @param int $cust_id
     * @param int $ccid
     * @param int $did
     * @param string $received
     * @param int $bizarea
     * @param int $location
     * @param string $from_date
     * @param string $to_date
     * @param int $billing_ccid
     * @param string $description
     * @param string $from_time
     * @param string $to_time
     * @param string $first_time
     * @param string $friday_time
     * @param string $reference
     * @param string $order_key
     * @param bool $use_order_key
     * @param float $planned_break
     * @param string $efaktura_ean_invoice
     * @param string $efaktura_ean_delivery
     * @param string $efaktura_orderno
     * @param string $efaktura_account
     * @param int $payment_customer
     * @param int $required_temps
     * @param float $budget_invoice_price
     * @param float $budget_payment_price
     * @param int $global_location
     * @param int $status_code
     * @param int $sdid
     * @param string $intern_note
     * @param bool $dont_book_holidays
     * @param string $manual_location
     * @param string $manual_address
     * @param string $manual_zip_city
     * @param string $manual_transport_info
     * @param int $manual_area
     * @param string $manual_phone
     * @param int $custom_timesheet_recipient
     * @param int $contract
     * @param int $customer_consultant
     */
    public function __construct($order_id = null, $cid = null, $cust_id = null, $ccid = null, $did = null, $received = null, $bizarea = null, $location = null, $from_date = null, $to_date = null, $billing_ccid = null, $description = null, $from_time = null, $to_time = null, $first_time = null, $friday_time = null, $reference = null, $order_key = null, $use_order_key = null, $planned_break = null, $efaktura_ean_invoice = null, $efaktura_ean_delivery = null, $efaktura_orderno = null, $efaktura_account = null, $payment_customer = null, $required_temps = null, $budget_invoice_price = null, $budget_payment_price = null, $global_location = null, $status_code = null, $sdid = null, $intern_note = null, $dont_book_holidays = null, $manual_location = null, $manual_address = null, $manual_zip_city = null, $manual_transport_info = null, $manual_area = null, $manual_phone = null, $custom_timesheet_recipient = null, $contract = null, $customer_consultant = null)
    {
        $this
            ->setOrder_id($order_id)
            ->setCid($cid)
            ->setCust_id($cust_id)
            ->setCcid($ccid)
            ->setDid($did)
            ->setReceived($received)
            ->setBizarea($bizarea)
            ->setLocation($location)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setBilling_ccid($billing_ccid)
            ->setDescription($description)
            ->setFrom_time($from_time)
            ->setTo_time($to_time)
            ->setFirst_time($first_time)
            ->setFriday_time($friday_time)
            ->setReference($reference)
            ->setOrder_key($order_key)
            ->setUse_order_key($use_order_key)
            ->setPlanned_break($planned_break)
            ->setEfaktura_ean_invoice($efaktura_ean_invoice)
            ->setEfaktura_ean_delivery($efaktura_ean_delivery)
            ->setEfaktura_orderno($efaktura_orderno)
            ->setEfaktura_account($efaktura_account)
            ->setPayment_customer($payment_customer)
            ->setRequired_temps($required_temps)
            ->setBudget_invoice_price($budget_invoice_price)
            ->setBudget_payment_price($budget_payment_price)
            ->setGlobal_location($global_location)
            ->setStatus_code($status_code)
            ->setSdid($sdid)
            ->setIntern_note($intern_note)
            ->setDont_book_holidays($dont_book_holidays)
            ->setManual_location($manual_location)
            ->setManual_address($manual_address)
            ->setManual_zip_city($manual_zip_city)
            ->setManual_transport_info($manual_transport_info)
            ->setManual_area($manual_area)
            ->setManual_phone($manual_phone)
            ->setCustom_timesheet_recipient($custom_timesheet_recipient)
            ->setContract($contract)
            ->setCustomer_consultant($customer_consultant);
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get cid value
     * @return int|null
     */
    public function getCid()
    {
        return $this->cid;
    }
    /**
     * Set cid value
     * @param int $cid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setCid($cid = null)
    {
        // validation for constraint: int
        if (!is_null($cid) && !is_numeric($cid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cid)), __LINE__);
        }
        $this->cid = $cid;
        return $this;
    }
    /**
     * Get cust_id value
     * @return int|null
     */
    public function getCust_id()
    {
        return $this->cust_id;
    }
    /**
     * Set cust_id value
     * @param int $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setCust_id($cust_id = null)
    {
        // validation for constraint: int
        if (!is_null($cust_id) && !is_numeric($cust_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_id)), __LINE__);
        }
        $this->cust_id = $cust_id;
        return $this;
    }
    /**
     * Get ccid value
     * @return int|null
     */
    public function getCcid()
    {
        return $this->ccid;
    }
    /**
     * Set ccid value
     * @param int $ccid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setCcid($ccid = null)
    {
        // validation for constraint: int
        if (!is_null($ccid) && !is_numeric($ccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ccid)), __LINE__);
        }
        $this->ccid = $ccid;
        return $this;
    }
    /**
     * Get did value
     * @return int|null
     */
    public function getDid()
    {
        return $this->did;
    }
    /**
     * Set did value
     * @param int $did
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setDid($did = null)
    {
        // validation for constraint: int
        if (!is_null($did) && !is_numeric($did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($did)), __LINE__);
        }
        $this->did = $did;
        return $this;
    }
    /**
     * Get received value
     * @return string|null
     */
    public function getReceived()
    {
        return $this->received;
    }
    /**
     * Set received value
     * @param string $received
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setReceived($received = null)
    {
        // validation for constraint: string
        if (!is_null($received) && !is_string($received)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($received)), __LINE__);
        }
        $this->received = $received;
        return $this;
    }
    /**
     * Get bizarea value
     * @return int|null
     */
    public function getBizarea()
    {
        return $this->bizarea;
    }
    /**
     * Set bizarea value
     * @param int $bizarea
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setBizarea($bizarea = null)
    {
        // validation for constraint: int
        if (!is_null($bizarea) && !is_numeric($bizarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bizarea)), __LINE__);
        }
        $this->bizarea = $bizarea;
        return $this;
    }
    /**
     * Get location value
     * @return int|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param int $location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setLocation($location = null)
    {
        // validation for constraint: int
        if (!is_null($location) && !is_numeric($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get from_date value
     * @return string|null
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string|null
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get billing_ccid value
     * @return int|null
     */
    public function getBilling_ccid()
    {
        return $this->billing_ccid;
    }
    /**
     * Set billing_ccid value
     * @param int $billing_ccid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setBilling_ccid($billing_ccid = null)
    {
        // validation for constraint: int
        if (!is_null($billing_ccid) && !is_numeric($billing_ccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_ccid)), __LINE__);
        }
        $this->billing_ccid = $billing_ccid;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get from_time value
     * @return string|null
     */
    public function getFrom_time()
    {
        return $this->from_time;
    }
    /**
     * Set from_time value
     * @param string $from_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setFrom_time($from_time = null)
    {
        // validation for constraint: string
        if (!is_null($from_time) && !is_string($from_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_time)), __LINE__);
        }
        $this->from_time = $from_time;
        return $this;
    }
    /**
     * Get to_time value
     * @return string|null
     */
    public function getTo_time()
    {
        return $this->to_time;
    }
    /**
     * Set to_time value
     * @param string $to_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setTo_time($to_time = null)
    {
        // validation for constraint: string
        if (!is_null($to_time) && !is_string($to_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_time)), __LINE__);
        }
        $this->to_time = $to_time;
        return $this;
    }
    /**
     * Get first_time value
     * @return string|null
     */
    public function getFirst_time()
    {
        return $this->first_time;
    }
    /**
     * Set first_time value
     * @param string $first_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setFirst_time($first_time = null)
    {
        // validation for constraint: string
        if (!is_null($first_time) && !is_string($first_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first_time)), __LINE__);
        }
        $this->first_time = $first_time;
        return $this;
    }
    /**
     * Get friday_time value
     * @return string|null
     */
    public function getFriday_time()
    {
        return $this->friday_time;
    }
    /**
     * Set friday_time value
     * @param string $friday_time
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setFriday_time($friday_time = null)
    {
        // validation for constraint: string
        if (!is_null($friday_time) && !is_string($friday_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($friday_time)), __LINE__);
        }
        $this->friday_time = $friday_time;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get order_key value
     * @return string|null
     */
    public function getOrder_key()
    {
        return $this->order_key;
    }
    /**
     * Set order_key value
     * @param string $order_key
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setOrder_key($order_key = null)
    {
        // validation for constraint: string
        if (!is_null($order_key) && !is_string($order_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_key)), __LINE__);
        }
        $this->order_key = $order_key;
        return $this;
    }
    /**
     * Get use_order_key value
     * @return bool|null
     */
    public function getUse_order_key()
    {
        return $this->use_order_key;
    }
    /**
     * Set use_order_key value
     * @param bool $use_order_key
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setUse_order_key($use_order_key = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_order_key) && !is_bool($use_order_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($use_order_key)), __LINE__);
        }
        $this->use_order_key = $use_order_key;
        return $this;
    }
    /**
     * Get planned_break value
     * @return float|null
     */
    public function getPlanned_break()
    {
        return $this->planned_break;
    }
    /**
     * Set planned_break value
     * @param float $planned_break
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setPlanned_break($planned_break = null)
    {
        $this->planned_break = $planned_break;
        return $this;
    }
    /**
     * Get efaktura_ean_invoice value
     * @return string|null
     */
    public function getEfaktura_ean_invoice()
    {
        return $this->efaktura_ean_invoice;
    }
    /**
     * Set efaktura_ean_invoice value
     * @param string $efaktura_ean_invoice
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setEfaktura_ean_invoice($efaktura_ean_invoice = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_ean_invoice) && !is_string($efaktura_ean_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_ean_invoice)), __LINE__);
        }
        $this->efaktura_ean_invoice = $efaktura_ean_invoice;
        return $this;
    }
    /**
     * Get efaktura_ean_delivery value
     * @return string|null
     */
    public function getEfaktura_ean_delivery()
    {
        return $this->efaktura_ean_delivery;
    }
    /**
     * Set efaktura_ean_delivery value
     * @param string $efaktura_ean_delivery
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setEfaktura_ean_delivery($efaktura_ean_delivery = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_ean_delivery) && !is_string($efaktura_ean_delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_ean_delivery)), __LINE__);
        }
        $this->efaktura_ean_delivery = $efaktura_ean_delivery;
        return $this;
    }
    /**
     * Get efaktura_orderno value
     * @return string|null
     */
    public function getEfaktura_orderno()
    {
        return $this->efaktura_orderno;
    }
    /**
     * Set efaktura_orderno value
     * @param string $efaktura_orderno
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setEfaktura_orderno($efaktura_orderno = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_orderno) && !is_string($efaktura_orderno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_orderno)), __LINE__);
        }
        $this->efaktura_orderno = $efaktura_orderno;
        return $this;
    }
    /**
     * Get efaktura_account value
     * @return string|null
     */
    public function getEfaktura_account()
    {
        return $this->efaktura_account;
    }
    /**
     * Set efaktura_account value
     * @param string $efaktura_account
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setEfaktura_account($efaktura_account = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_account) && !is_string($efaktura_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_account)), __LINE__);
        }
        $this->efaktura_account = $efaktura_account;
        return $this;
    }
    /**
     * Get payment_customer value
     * @return int|null
     */
    public function getPayment_customer()
    {
        return $this->payment_customer;
    }
    /**
     * Set payment_customer value
     * @param int $payment_customer
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setPayment_customer($payment_customer = null)
    {
        // validation for constraint: int
        if (!is_null($payment_customer) && !is_numeric($payment_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payment_customer)), __LINE__);
        }
        $this->payment_customer = $payment_customer;
        return $this;
    }
    /**
     * Get required_temps value
     * @return int|null
     */
    public function getRequired_temps()
    {
        return $this->required_temps;
    }
    /**
     * Set required_temps value
     * @param int $required_temps
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setRequired_temps($required_temps = null)
    {
        // validation for constraint: int
        if (!is_null($required_temps) && !is_numeric($required_temps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($required_temps)), __LINE__);
        }
        $this->required_temps = $required_temps;
        return $this;
    }
    /**
     * Get budget_invoice_price value
     * @return float|null
     */
    public function getBudget_invoice_price()
    {
        return $this->budget_invoice_price;
    }
    /**
     * Set budget_invoice_price value
     * @param float $budget_invoice_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setBudget_invoice_price($budget_invoice_price = null)
    {
        $this->budget_invoice_price = $budget_invoice_price;
        return $this;
    }
    /**
     * Get budget_payment_price value
     * @return float|null
     */
    public function getBudget_payment_price()
    {
        return $this->budget_payment_price;
    }
    /**
     * Set budget_payment_price value
     * @param float $budget_payment_price
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setBudget_payment_price($budget_payment_price = null)
    {
        $this->budget_payment_price = $budget_payment_price;
        return $this;
    }
    /**
     * Get global_location value
     * @return int|null
     */
    public function getGlobal_location()
    {
        return $this->global_location;
    }
    /**
     * Set global_location value
     * @param int $global_location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setGlobal_location($global_location = null)
    {
        // validation for constraint: int
        if (!is_null($global_location) && !is_numeric($global_location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($global_location)), __LINE__);
        }
        $this->global_location = $global_location;
        return $this;
    }
    /**
     * Get status_code value
     * @return int|null
     */
    public function getStatus_code()
    {
        return $this->status_code;
    }
    /**
     * Set status_code value
     * @param int $status_code
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setStatus_code($status_code = null)
    {
        // validation for constraint: int
        if (!is_null($status_code) && !is_numeric($status_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status_code)), __LINE__);
        }
        $this->status_code = $status_code;
        return $this;
    }
    /**
     * Get sdid value
     * @return int|null
     */
    public function getSdid()
    {
        return $this->sdid;
    }
    /**
     * Set sdid value
     * @param int $sdid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setSdid($sdid = null)
    {
        // validation for constraint: int
        if (!is_null($sdid) && !is_numeric($sdid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sdid)), __LINE__);
        }
        $this->sdid = $sdid;
        return $this;
    }
    /**
     * Get intern_note value
     * @return string|null
     */
    public function getIntern_note()
    {
        return $this->intern_note;
    }
    /**
     * Set intern_note value
     * @param string $intern_note
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setIntern_note($intern_note = null)
    {
        // validation for constraint: string
        if (!is_null($intern_note) && !is_string($intern_note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intern_note)), __LINE__);
        }
        $this->intern_note = $intern_note;
        return $this;
    }
    /**
     * Get dont_book_holidays value
     * @return bool|null
     */
    public function getDont_book_holidays()
    {
        return $this->dont_book_holidays;
    }
    /**
     * Set dont_book_holidays value
     * @param bool $dont_book_holidays
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setDont_book_holidays($dont_book_holidays = null)
    {
        // validation for constraint: boolean
        if (!is_null($dont_book_holidays) && !is_bool($dont_book_holidays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dont_book_holidays)), __LINE__);
        }
        $this->dont_book_holidays = $dont_book_holidays;
        return $this;
    }
    /**
     * Get manual_location value
     * @return string|null
     */
    public function getManual_location()
    {
        return $this->manual_location;
    }
    /**
     * Set manual_location value
     * @param string $manual_location
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_location($manual_location = null)
    {
        // validation for constraint: string
        if (!is_null($manual_location) && !is_string($manual_location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_location)), __LINE__);
        }
        $this->manual_location = $manual_location;
        return $this;
    }
    /**
     * Get manual_address value
     * @return string|null
     */
    public function getManual_address()
    {
        return $this->manual_address;
    }
    /**
     * Set manual_address value
     * @param string $manual_address
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_address($manual_address = null)
    {
        // validation for constraint: string
        if (!is_null($manual_address) && !is_string($manual_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_address)), __LINE__);
        }
        $this->manual_address = $manual_address;
        return $this;
    }
    /**
     * Get manual_zip_city value
     * @return string|null
     */
    public function getManual_zip_city()
    {
        return $this->manual_zip_city;
    }
    /**
     * Set manual_zip_city value
     * @param string $manual_zip_city
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_zip_city($manual_zip_city = null)
    {
        // validation for constraint: string
        if (!is_null($manual_zip_city) && !is_string($manual_zip_city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_zip_city)), __LINE__);
        }
        $this->manual_zip_city = $manual_zip_city;
        return $this;
    }
    /**
     * Get manual_transport_info value
     * @return string|null
     */
    public function getManual_transport_info()
    {
        return $this->manual_transport_info;
    }
    /**
     * Set manual_transport_info value
     * @param string $manual_transport_info
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_transport_info($manual_transport_info = null)
    {
        // validation for constraint: string
        if (!is_null($manual_transport_info) && !is_string($manual_transport_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_transport_info)), __LINE__);
        }
        $this->manual_transport_info = $manual_transport_info;
        return $this;
    }
    /**
     * Get manual_area value
     * @return int|null
     */
    public function getManual_area()
    {
        return $this->manual_area;
    }
    /**
     * Set manual_area value
     * @param int $manual_area
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_area($manual_area = null)
    {
        // validation for constraint: int
        if (!is_null($manual_area) && !is_numeric($manual_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manual_area)), __LINE__);
        }
        $this->manual_area = $manual_area;
        return $this;
    }
    /**
     * Get manual_phone value
     * @return string|null
     */
    public function getManual_phone()
    {
        return $this->manual_phone;
    }
    /**
     * Set manual_phone value
     * @param string $manual_phone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setManual_phone($manual_phone = null)
    {
        // validation for constraint: string
        if (!is_null($manual_phone) && !is_string($manual_phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manual_phone)), __LINE__);
        }
        $this->manual_phone = $manual_phone;
        return $this;
    }
    /**
     * Get custom_timesheet_recipient value
     * @return int|null
     */
    public function getCustom_timesheet_recipient()
    {
        return $this->custom_timesheet_recipient;
    }
    /**
     * Set custom_timesheet_recipient value
     * @param int $custom_timesheet_recipient
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setCustom_timesheet_recipient($custom_timesheet_recipient = null)
    {
        // validation for constraint: int
        if (!is_null($custom_timesheet_recipient) && !is_numeric($custom_timesheet_recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($custom_timesheet_recipient)), __LINE__);
        }
        $this->custom_timesheet_recipient = $custom_timesheet_recipient;
        return $this;
    }
    /**
     * Get contract value
     * @return int|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param int $contract
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setContract($contract = null)
    {
        // validation for constraint: int
        if (!is_null($contract) && !is_numeric($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contract)), __LINE__);
        }
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get customer_consultant value
     * @return int|null
     */
    public function getCustomer_consultant()
    {
        return $this->customer_consultant;
    }
    /**
     * Set customer_consultant value
     * @param int $customer_consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public function setCustomer_consultant($customer_consultant = null)
    {
        // validation for constraint: int
        if (!is_null($customer_consultant) && !is_numeric($customer_consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_consultant)), __LINE__);
        }
        $this->customer_consultant = $customer_consultant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpTempOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
